/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.plexus.archiver.tar;

import coursierapi.shaded.commonscompress.archivers.tar.TarArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.tar.TarArchiveInputStream;
import coursierapi.shaded.commonscompress.compressors.bzip2.BZip2CompressorInputStream;
import coursierapi.shaded.commonscompress.compressors.xz.XZCompressorInputStream;
import coursierapi.shaded.plexus.archiver.AbstractUnArchiver;
import coursierapi.shaded.plexus.archiver.ArchiverException;
import coursierapi.shaded.plexus.archiver.tar.TarFile;
import coursierapi.shaded.plexus.archiver.tar.TarResource;
import coursierapi.shaded.plexus.archiver.util.Streams;
import coursierapi.shaded.plexus.components.io.filemappers.FileMapper;
import coursierapi.shaded.snappy.SnappyInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class TarUnArchiver
extends AbstractUnArchiver {
    private UntarCompressionMethod compression = UntarCompressionMethod.NONE;

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    @Override
    protected void execute() throws ArchiverException {
        this.execute(this.getSourceFile(), this.getDestDirectory(), this.getFileMappers());
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        this.execute(new File(path), this.getDestDirectory(), this.getFileMappers());
    }

    protected void execute(File sourceFile, File destDirectory, FileMapper[] fileMappers) throws ArchiverException {
        try {
            this.getLogger().info("Expanding: " + sourceFile + " into " + destDirectory);
            TarFile tarFile = new TarFile(sourceFile);
            try (TarArchiveInputStream tis = new TarArchiveInputStream(this.decompress(this.compression, sourceFile, Streams.bufferedInputStream(Streams.fileInputStream(sourceFile))));){
                TarArchiveEntry te;
                while ((te = tis.getNextTarEntry()) != null) {
                    TarResource fileInfo = new TarResource(tarFile, te);
                    if (!this.isSelected(te.getName(), fileInfo)) continue;
                    String symlinkDestination = te.isSymbolicLink() ? te.getLinkName() : null;
                    this.extractFile(sourceFile, destDirectory, tis, te.getName(), te.getModTime(), te.isDirectory(), te.getMode() != 0 ? Integer.valueOf(te.getMode()) : null, symlinkDestination, fileMappers);
                }
                this.getLogger().debug("expand complete");
            }
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + sourceFile.getAbsolutePath(), ioe);
        }
    }

    private InputStream decompress(UntarCompressionMethod compression, File file, InputStream istream) throws IOException, ArchiverException {
        if (compression == UntarCompressionMethod.GZIP) {
            return Streams.bufferedInputStream(new GZIPInputStream(istream));
        }
        if (compression == UntarCompressionMethod.BZIP2) {
            return new BZip2CompressorInputStream(istream);
        }
        if (compression == UntarCompressionMethod.SNAPPY) {
            return new SnappyInputStream(istream, true);
        }
        if (compression == UntarCompressionMethod.XZ) {
            return new XZCompressorInputStream(istream);
        }
        return istream;
    }

    public static final class UntarCompressionMethod
    extends Enum<UntarCompressionMethod> {
        public static final /* enum */ UntarCompressionMethod NONE = new UntarCompressionMethod("none");
        public static final /* enum */ UntarCompressionMethod GZIP = new UntarCompressionMethod("gzip");
        public static final /* enum */ UntarCompressionMethod BZIP2 = new UntarCompressionMethod("bzip2");
        public static final /* enum */ UntarCompressionMethod SNAPPY = new UntarCompressionMethod("snappy");
        public static final /* enum */ UntarCompressionMethod XZ = new UntarCompressionMethod("xz");
        final String value;
        private static final /* synthetic */ UntarCompressionMethod[] $VALUES;

        private UntarCompressionMethod(String value) {
            this.value = value;
        }

        static {
            $VALUES = new UntarCompressionMethod[]{NONE, GZIP, BZIP2, SNAPPY, XZ};
        }
    }
}

