/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.repository;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.model.oaipmh.DeletedRecord;
import io.gdcc.xoai.model.oaipmh.Granularity;
import io.gdcc.xoai.services.api.ResumptionTokenFormat;
import io.gdcc.xoai.services.impl.SimpleResumptionTokenFormat;
import io.gdcc.xoai.xml.WriterContext;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RepositoryConfiguration
implements WriterContext {
    private final List<String> adminEmails = new ArrayList<String>();
    private final List<String> descriptions = new ArrayList<String>();
    private final List<String> compressions = new ArrayList<String>();
    private final Granularity granularity;
    private final ResumptionTokenFormat resumptionTokenFormat;
    private final String repositoryName;
    private final String baseUrl;
    private final Instant earliestDate;
    private final Integer maxListIdentifiers;
    private final Integer maxListSets;
    private final Integer maxListRecords;
    private final DeletedRecord deleteMethod;
    private final boolean enableMetadataAttributes;
    private final boolean requireFromAfterEarliest;

    RepositoryConfiguration(List<String> adminEmails, List<String> descriptions, List<String> compressions, Granularity granularity, ResumptionTokenFormat resumptionTokenFormat, String repositoryName, String baseUrl, Instant earliestDate, Integer maxListIdentifiers, Integer maxListSets, Integer maxListRecords, DeletedRecord deleteMethod, boolean enableMetadataAttributes, boolean requireFromAfterEarliest) {
        this.adminEmails.addAll(List.copyOf(adminEmails));
        this.descriptions.addAll(List.copyOf(descriptions));
        this.compressions.addAll(List.copyOf(compressions));
        this.granularity = granularity;
        this.resumptionTokenFormat = resumptionTokenFormat;
        this.repositoryName = repositoryName;
        this.baseUrl = baseUrl;
        this.earliestDate = earliestDate;
        this.maxListIdentifiers = maxListIdentifiers;
        this.maxListSets = maxListSets;
        this.maxListRecords = maxListRecords;
        this.deleteMethod = deleteMethod;
        this.enableMetadataAttributes = enableMetadataAttributes;
        this.requireFromAfterEarliest = requireFromAfterEarliest;
    }

    public RepositoryConfigurationBuilder asTemplate() {
        RepositoryConfigurationBuilder builder = new RepositoryConfigurationBuilder().setAdminEmails(this.adminEmails).withGranularity(this.granularity).withResumptionTokenFormat(this.resumptionTokenFormat).withRepositoryName(this.repositoryName).withBaseUrl(this.baseUrl).withEarliestDate(this.earliestDate).withMaxListIdentifiers(this.maxListIdentifiers).withMaxListSets(this.maxListSets).withMaxListRecords(this.maxListRecords).withDeleteMethod(this.deleteMethod).withEnableMetadataAttributes(this.enableMetadataAttributes).withRequireFromAfterEarliest(this.requireFromAfterEarliest);
        builder.descriptions.clear();
        builder.descriptions.addAll(this.descriptions);
        builder.compressions.clear();
        builder.compressions.addAll(this.compressions);
        return builder;
    }

    public void inject(Repository repository) {
        repository.setConfiguration(this);
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            throw new InternalOAIException("Repository name has not been configured");
        }
        return this.repositoryName;
    }

    public List<String> getAdminEmails() {
        return Collections.unmodifiableList(this.adminEmails);
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            throw new InternalOAIException("Repository base URL has not been configured");
        }
        return this.baseUrl;
    }

    public Instant getEarliestDate() {
        if (this.earliestDate == null) {
            throw new InternalOAIException("Earliest date has not been configured");
        }
        return this.earliestDate;
    }

    public int getMaxListIdentifiers() {
        if (this.maxListIdentifiers == null) {
            throw new InternalOAIException("Maximum number of identifiers has not been configured");
        }
        return this.maxListIdentifiers;
    }

    public int getMaxListSets() {
        if (this.maxListSets == null) {
            throw new InternalOAIException("Maximum number of sets has not been configured");
        }
        return this.maxListSets;
    }

    public int getMaxListRecords() {
        if (this.maxListRecords == null) {
            throw new InternalOAIException("Maximum number of records has not been configured");
        }
        return this.maxListRecords;
    }

    public Granularity getGranularity() {
        if (this.granularity == null) {
            throw new InternalOAIException("Granularity has not been configured");
        }
        return this.granularity;
    }

    public Instant skewUntil(Instant timestamp) {
        Objects.requireNonNull(timestamp, "Skewing an 'until' date must not be used with null");
        switch (this.getGranularity()) {
            case Day: 
            case Lenient: {
                return LocalDate.ofInstant(timestamp, ZoneId.of("UTC")).atTime(LocalTime.MAX).toInstant(ZoneOffset.UTC);
            }
            case Second: {
                return timestamp.plusSeconds(1L);
            }
        }
        return timestamp;
    }

    public DeletedRecord getDeleteMethod() {
        if (this.deleteMethod == null) {
            throw new InternalOAIException("Delete method has not been configured");
        }
        return this.deleteMethod;
    }

    public List<String> getDescription() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public List<String> getCompressions() {
        return Collections.unmodifiableList(this.compressions);
    }

    public boolean hasCompressions() {
        return !this.compressions.isEmpty();
    }

    public ResumptionTokenFormat getResumptionTokenFormat() {
        if (this.resumptionTokenFormat == null) {
            throw new InternalOAIException("Resumption token format has not been configured");
        }
        return this.resumptionTokenFormat;
    }

    public boolean isMetadataAttributesEnabled() {
        return this.enableMetadataAttributes;
    }

    public boolean requiresFromAfterEarliest() {
        return this.requireFromAfterEarliest;
    }

    public static final class RepositoryConfigurationBuilder {
        final List<String> adminEmails = new ArrayList<String>();
        final List<String> descriptions = new ArrayList<String>();
        final List<String> compressions = new ArrayList<String>();
        Granularity granularity = Granularity.Second;
        ResumptionTokenFormat resumptionTokenFormat = new SimpleResumptionTokenFormat().withGranularity(Granularity.Second);
        String repositoryName;
        String baseUrl;
        Instant earliestDate;
        DeletedRecord deleteMethod;
        Integer maxListIdentifiers = 100;
        Integer maxListSets = 100;
        Integer maxListRecords = 100;
        Boolean enableMetadataAttributes = false;
        Boolean requireFromAfterEarliest = false;

        public RepositoryConfigurationBuilder withGranularity(Granularity granularity) {
            this.requireNotNull(granularity, "Granularity must not be null");
            this.granularity = granularity;
            return this;
        }

        public RepositoryConfigurationBuilder withRepositoryName(String repositoryName) {
            this.requireNotNullNotEmpty(repositoryName, "Repository name must not be null or empty");
            this.repositoryName = repositoryName;
            return this;
        }

        public RepositoryConfigurationBuilder setAdminEmails(List<String> emails) {
            this.requireNotNull(emails, "Admin emails list must not be null");
            if (emails.isEmpty()) {
                throw new IllegalArgumentException("Admin emails list must not be empty");
            }
            return this.setAdminEmails((String[])emails.toArray(String[]::new));
        }

        public RepositoryConfigurationBuilder setAdminEmails(String ... emails) {
            List<String> backup = List.copyOf(this.adminEmails);
            this.adminEmails.clear();
            try {
                return this.withAdminEmails(emails);
            }
            catch (IllegalArgumentException e) {
                this.adminEmails.addAll(backup);
                throw e;
            }
        }

        public RepositoryConfigurationBuilder withAdminEmails(String ... emails) {
            this.requireNotNull(emails, "Admin email list must not be null");
            if (emails.length == 0) {
                throw new IllegalArgumentException("Admin emails list must not be empty");
            }
            for (String s : emails) {
                this.requireNotNullNotEmpty(s, "Admin email must not be null or empty in list ('" + String.join((CharSequence)"', '", emails) + "')");
            }
            this.adminEmails.addAll(Arrays.asList(emails));
            return this;
        }

        public RepositoryConfigurationBuilder withAdminEmail(String email) {
            this.requireNotNullNotEmpty(email, "Admin email must not be null or empty");
            this.adminEmails.add(email);
            return this;
        }

        public RepositoryConfigurationBuilder withDeleteMethod(DeletedRecord deleteMethod) {
            this.requireNotNull(deleteMethod, "Deletion Method must not be null");
            this.deleteMethod = deleteMethod;
            return this;
        }

        public RepositoryConfigurationBuilder withDescription(String description) {
            this.requireNotNullNotEmpty(description, "Description must not be null or empty");
            this.descriptions.add(description);
            return this;
        }

        public RepositoryConfigurationBuilder withBaseUrl(String baseUrl) {
            this.requireNotNullNotEmpty(baseUrl, "Base URL must not be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public RepositoryConfigurationBuilder withEarliestDate(Instant earliestDate) {
            this.requireNotNull(earliestDate, "Earliest date must not be null");
            if (earliestDate.isAfter(Instant.now())) {
                throw new IllegalArgumentException("Earliest date cannot lie in the future (given: " + earliestDate.truncatedTo(ChronoUnit.SECONDS).toString() + ")");
            }
            this.earliestDate = earliestDate;
            return this;
        }

        public RepositoryConfigurationBuilder withCompression(String compression) {
            this.requireNotNullNotEmpty(compression, "Compression must not be null or empty");
            this.compressions.add(compression);
            return this;
        }

        public RepositoryConfigurationBuilder withMaxListRecords(int maxListRecords) {
            if (maxListRecords < 1) {
                throw new IllegalArgumentException("Maximum ListRecords response size must be greater 0");
            }
            this.maxListRecords = maxListRecords;
            return this;
        }

        public RepositoryConfigurationBuilder withMaxListIdentifiers(int maxListIdentifiers) {
            if (maxListIdentifiers < 1) {
                throw new IllegalArgumentException("Maximum ListIdentifiers response size must be greater 0");
            }
            this.maxListIdentifiers = maxListIdentifiers;
            return this;
        }

        public RepositoryConfigurationBuilder withMaxListSets(int maxListSets) {
            if (maxListSets < 1) {
                throw new IllegalArgumentException("Maximum ListSets response size must be greater 0");
            }
            this.maxListSets = maxListSets;
            return this;
        }

        public RepositoryConfigurationBuilder withResumptionTokenFormat(ResumptionTokenFormat format) {
            this.requireNotNull(format, "Resumption Token Format must not be null");
            this.resumptionTokenFormat = format;
            return this;
        }

        @Deprecated(since="5.0")
        public RepositoryConfigurationBuilder withEnableMetadataAttributes(boolean enable) {
            this.enableMetadataAttributes = enable;
            return this;
        }

        public RepositoryConfigurationBuilder withRequireFromAfterEarliest(boolean require) {
            this.requireFromAfterEarliest = require;
            return this;
        }

        public RepositoryConfiguration build() {
            if (this.adminEmails.isEmpty()) {
                throw new IllegalArgumentException("Missing admin email address/es");
            }
            this.requireNotNullNotEmpty(this.baseUrl, "Missing base URL");
            this.requireNotNullNotEmpty(this.repositoryName, "Missing repository name");
            this.requireNotNull(this.earliestDate, "Missing 'earliest date', which is the date of the first inserted item");
            this.requireNotNull(this.deleteMethod, "Missing delete method");
            return new RepositoryConfiguration(this.adminEmails, this.descriptions, this.compressions, this.granularity, this.resumptionTokenFormat, this.repositoryName, this.baseUrl, this.earliestDate, this.maxListIdentifiers, this.maxListSets, this.maxListRecords, this.deleteMethod, this.enableMetadataAttributes, this.requireFromAfterEarliest);
        }

        public void requireNotNull(Object o, String message) {
            if (o == null) {
                throw new IllegalArgumentException(message);
            }
        }

        public void requireNotNullNotEmpty(String s, String message) {
            if (s == null || s.isEmpty()) {
                throw new IllegalArgumentException(message);
            }
        }
    }
}

