/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.model;

import io.gdcc.xoai.dataprovider.filter.Condition;
import io.gdcc.xoai.dataprovider.filter.Scope;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.model.ItemIdentifier;
import io.gdcc.xoai.model.xoai.XOAIMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Set {
    private final String spec;
    private final List<XOAIMetadata> descriptions = new ArrayList<XOAIMetadata>();
    private String name;
    private Condition condition;

    public static Set set(String spec) {
        return new Set(spec);
    }

    public Set(String spec) {
        this.spec = spec;
    }

    public String getName() {
        return this.name;
    }

    public Set withName(String name) {
        this.name = name;
        return this;
    }

    public List<XOAIMetadata> getDescriptions() {
        return this.descriptions;
    }

    public Set withDescription(XOAIMetadata description) {
        this.descriptions.add(description);
        return this;
    }

    public boolean hasDescription() {
        return !this.descriptions.isEmpty();
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public Set withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public boolean isItemShown(ItemIdentifier item) {
        return item != null && this.condition == null || this.condition.isItemShown(item);
    }

    public ScopedFilter getScopedFilter() {
        return new ScopedFilter(this.condition == null ? Condition.ALWAYS_TRUE : this.condition, Scope.Set);
    }

    public String getSpec() {
        return this.spec;
    }

    public io.gdcc.xoai.model.oaipmh.results.Set toOAIPMH() {
        io.gdcc.xoai.model.oaipmh.results.Set set = new io.gdcc.xoai.model.oaipmh.results.Set().withName(this.getName()).withSpec(this.getSpec());
        for (XOAIMetadata description : this.descriptions) {
            set.withDescription(description);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set set = (Set)o;
        return Objects.equals(this.getSpec(), set.getSpec());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

