/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.model;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.filter.Condition;
import io.gdcc.xoai.dataprovider.filter.Scope;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.model.ItemIdentifier;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class MetadataFormat {
    private Condition condition;
    private String prefix;
    private Transformer transformer;
    private String namespace;
    private String schemaLocation;

    public static Transformer identity() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            return factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new InternalOAIException("Could not setup the identity transformer", e);
        }
    }

    public static MetadataFormat metadataFormat(String prefix) {
        return new MetadataFormat().withPrefix(prefix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public MetadataFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public MetadataFormat withTransformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetadataFormat withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public MetadataFormat withSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    public MetadataFormat withCondition(Condition filter) {
        this.condition = filter;
        return this;
    }

    public ScopedFilter getScopedFilter() {
        return new ScopedFilter(this.condition == null ? Condition.ALWAYS_TRUE : this.condition, Scope.MetadataFormat);
    }

    public boolean isItemShown(ItemIdentifier item) {
        return item != null && this.condition == null || this.condition.isItemShown(item);
    }

    public io.gdcc.xoai.model.oaipmh.results.MetadataFormat toOAIPMH() {
        return new io.gdcc.xoai.model.oaipmh.results.MetadataFormat().withMetadataNamespace(this.namespace).withMetadataPrefix(this.prefix).withSchema(this.schemaLocation);
    }
}

