/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.model;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.filter.Condition;
import io.gdcc.xoai.dataprovider.filter.Scope;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.model.ItemIdentifier;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.model.Set;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;

public class Context {
    private Transformer metadataTransformer = null;
    private final List<MetadataFormat> metadataFormats = new ArrayList<MetadataFormat>();
    private final List<Set> sets = new ArrayList<Set>();
    private Condition condition = null;

    public static Context context() {
        return new Context();
    }

    public List<Set> getSets() {
        return Collections.unmodifiableList(this.sets);
    }

    public Context withSet(Set set) {
        if (!set.hasCondition()) {
            throw new InternalOAIException("Context sets must have a condition");
        }
        this.sets.add(set);
        return this;
    }

    public boolean hasSet(String setSpec) {
        return this.isStaticSet(setSpec);
    }

    public boolean isStaticSet(String setSpec) {
        return this.sets.stream().anyMatch(set -> set.getSpec().equals(setSpec));
    }

    public Optional<Set> getSet(String setSpec) {
        return this.sets.stream().filter(set -> set.getSpec().equals(setSpec)).findAny();
    }

    public Stream<Set> getSetsForItem(ItemIdentifier item) {
        return this.sets.stream().filter(set -> set.isItemShown(item));
    }

    public Transformer getTransformer() {
        return this.metadataTransformer;
    }

    public Context withTransformer(Transformer metadataTransformer) {
        this.metadataTransformer = metadataTransformer;
        return this;
    }

    public List<MetadataFormat> getMetadataFormats() {
        return List.copyOf(this.metadataFormats);
    }

    public Context withMetadataFormat(MetadataFormat metadataFormat) {
        int remove = -1;
        for (int i = 0; i < this.metadataFormats.size(); ++i) {
            if (!this.metadataFormats.get(i).getPrefix().equals(metadataFormat.getPrefix())) continue;
            remove = i;
        }
        if (remove >= 0) {
            this.metadataFormats.remove(remove);
        }
        this.metadataFormats.add(metadataFormat);
        return this;
    }

    public Context withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public boolean isItemShown(ItemIdentifier item) {
        return item != null && this.condition == null || this.condition.isItemShown(item);
    }

    public ScopedFilter getScopedFilter() {
        return new ScopedFilter(this.condition != null ? this.condition : Condition.ALWAYS_TRUE, Scope.Context);
    }

    public MetadataFormat formatForPrefix(String metadataPrefix) {
        for (MetadataFormat format : this.metadataFormats) {
            if (!format.getPrefix().equals(metadataPrefix)) continue;
            return format;
        }
        return null;
    }

    public boolean hasTransformer() {
        return this.metadataTransformer != null;
    }

    public Context withMetadataFormat(String prefix, Transformer transformer) {
        this.withMetadataFormat(new MetadataFormat().withNamespace(prefix).withPrefix(prefix).withSchemaLocation(prefix).withTransformer(transformer));
        return this;
    }

    public Context withMetadataFormat(String prefix, Transformer transformer, Condition condition) {
        this.withMetadataFormat(new MetadataFormat().withNamespace(prefix).withPrefix(prefix).withSchemaLocation(prefix).withTransformer(transformer).withCondition(condition));
        return this;
    }

    public Context withoutMetadataFormats() {
        this.metadataFormats.clear();
        return this;
    }

    public List<MetadataFormat> formatFor(ItemIdentifier item) {
        ArrayList<MetadataFormat> result = new ArrayList<MetadataFormat>();
        for (MetadataFormat format : this.metadataFormats) {
            if (!format.isItemShown(item)) continue;
            result.add(format);
        }
        return result;
    }
}

