/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.exceptions.handler.CannotDisseminateFormatException;
import io.gdcc.xoai.dataprovider.exceptions.handler.DoesNotSupportSetsException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.NoMatchesException;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.model.Set;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.dataprovider.repository.RepositoryConfiguration;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class VerbHandler<T extends Verb> {
    private final Context context;
    private final Repository repository;

    protected VerbHandler(Context context, Repository repository) {
        this.context = context;
        this.repository = repository;
    }

    protected Context getContext() {
        return this.context;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected RepositoryConfiguration getConfiguration() {
        return this.repository.getConfiguration();
    }

    protected void verifySet(ResumptionToken.Value token) throws HandlerException {
        String requestedSet = token.getSetSpec();
        if (requestedSet != null) {
            if (!this.getRepository().getSetRepository().supportSets()) {
                throw new DoesNotSupportSetsException();
            }
            if (!this.getRepository().getSetRepository().exists(requestedSet) && !this.getContext().hasSet(requestedSet)) {
                throw new NoMatchesException("Requested set '" + requestedSet + "' does not exist");
            }
        }
    }

    protected MetadataFormat verifyFormat(ResumptionToken.Value token) throws HandlerException {
        String requestedFormat = Optional.ofNullable(token.getMetadataPrefix()).orElseThrow(() -> new CannotDisseminateFormatException("Missing required argument 'metadataPrefix'"));
        return Optional.ofNullable(this.getContext().formatForPrefix(requestedFormat)).orElseThrow(() -> new CannotDisseminateFormatException("Format '" + requestedFormat + "' not applicable in this context"));
    }

    protected List<ScopedFilter> createFilters(ResumptionToken.Value token, MetadataFormat format) {
        ArrayList<ScopedFilter> filters = new ArrayList<ScopedFilter>();
        filters.add(this.getContext().getScopedFilter());
        filters.add(format.getScopedFilter());
        Optional.ofNullable(token.getSetSpec()).flatMap(setSpec -> this.getContext().getSet((String)setSpec)).map(Set::getScopedFilter).ifPresent(filters::add);
        return filters;
    }

    public T handle(Request request) throws HandlerException {
        throw new InternalOAIException("Unsupported method for this handler!");
    }

    public T handle(ResumptionToken.Value token) throws HandlerException {
        throw new InternalOAIException("Unsupported method for this handler!");
    }
}

