/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.NoMetadataFormatsException;
import io.gdcc.xoai.dataprovider.handlers.VerbHandler;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.ItemIdentifier;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.repository.ItemRepository;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.verbs.ListMetadataFormats;
import java.util.ArrayList;
import java.util.Optional;

public class ListMetadataFormatsHandler
extends VerbHandler<ListMetadataFormats> {
    private final ItemRepository itemRepository;

    public ListMetadataFormatsHandler(Context context, Repository repository) {
        super(context, repository);
        this.itemRepository = repository.getItemRepository();
        if (this.getContext().getMetadataFormats() == null || this.getContext().getMetadataFormats().isEmpty()) {
            throw new InternalOAIException("The context must expose at least one metadata format");
        }
    }

    @Override
    public ListMetadataFormats handle(Request request) throws HandlerException {
        ArrayList<MetadataFormat> formats = new ArrayList<MetadataFormat>();
        Optional identifier = request.getIdentifier();
        if (identifier.isPresent()) {
            ItemIdentifier item = this.itemRepository.getItemIdentifier((String)identifier.get());
            formats.addAll(this.getContext().formatFor(item));
        } else {
            formats.addAll(this.getContext().getMetadataFormats());
        }
        if (formats.isEmpty()) {
            throw new NoMetadataFormatsException();
        }
        ListMetadataFormats result = new ListMetadataFormats();
        formats.forEach(format -> result.withMetadataFormat(format.toOAIPMH()));
        return result;
    }
}

