/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.exceptions.InternalOAIException;
import io.gdcc.xoai.dataprovider.exceptions.handler.HandlerException;
import io.gdcc.xoai.dataprovider.exceptions.handler.NoMatchesException;
import io.gdcc.xoai.dataprovider.filter.ScopedFilter;
import io.gdcc.xoai.dataprovider.handlers.VerbHandler;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.model.ItemIdentifier;
import io.gdcc.xoai.dataprovider.model.MetadataFormat;
import io.gdcc.xoai.dataprovider.model.Set;
import io.gdcc.xoai.dataprovider.repository.ItemRepository;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.dataprovider.repository.ResultsPage;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.verbs.ListIdentifiers;
import java.util.List;

public class ListIdentifiersHandler
extends VerbHandler<ListIdentifiers> {
    private final ItemRepository itemRepository;

    public ListIdentifiersHandler(Context context, Repository repository) {
        super(context, repository);
        this.itemRepository = repository.getItemRepository();
    }

    @Override
    public ListIdentifiers handle(ResumptionToken.Value token) throws HandlerException {
        if (token == null || token.isEmpty()) {
            throw new InternalOAIException("Resumption token must not be null or empty - check your implementation!");
        }
        this.verifySet(token);
        MetadataFormat format = this.verifyFormat(token);
        List<ScopedFilter> filters = this.createFilters(token, format);
        ResultsPage<ItemIdentifier> results = this.itemRepository.getItemIdentifiers(filters, format, this.getConfiguration().getMaxListIdentifiers(), token);
        if (results.getTotal() == 0) {
            throw new NoMatchesException();
        }
        ListIdentifiers response = new ListIdentifiers();
        results.getList().forEach(item -> response.getHeaders().add(this.createHeader((ItemIdentifier)item, format)));
        results.getResponseToken(this.getConfiguration().getMaxListIdentifiers()).ifPresent(arg_0 -> ((ListIdentifiers)response).withResumptionToken(arg_0));
        return response;
    }

    private Header createHeader(ItemIdentifier itemIdentifier, MetadataFormat format) {
        if (!itemIdentifier.isDeleted() && !format.isItemShown(itemIdentifier)) {
            throw new InternalOAIException("The item repository is currently providing items which cannot be disseminated with format " + format.getPrefix());
        }
        Header header = new Header();
        header.withDatestamp(itemIdentifier.getDatestamp());
        header.withIdentifier(itemIdentifier.getIdentifier());
        if (itemIdentifier.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        }
        for (Set set : this.getContext().getSets()) {
            if (!set.isItemShown(itemIdentifier)) continue;
            header.withSetSpec(set.getSpec());
        }
        for (Set set : itemIdentifier.getSets()) {
            header.withSetSpec(set.getSpec());
        }
        return header;
    }
}

