/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider.handlers;

import io.gdcc.xoai.dataprovider.repository.RepositoryConfiguration;
import io.gdcc.xoai.dataprovider.request.RequestBuilder;
import io.gdcc.xoai.exceptions.OAIException;
import io.gdcc.xoai.model.oaipmh.Error;
import io.gdcc.xoai.model.oaipmh.OAIPMH;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.services.api.DateProvider;
import java.util.Objects;

public class ErrorHandler {
    private final RepositoryConfiguration configuration;

    public ErrorHandler(RepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public OAIPMH handle(OAIPMH oaipmh, OAIException ex) {
        Objects.requireNonNull(oaipmh);
        Objects.requireNonNull(ex);
        return oaipmh.withRequest(new Request(this.configuration.getBaseUrl())).withResponseDate(DateProvider.now()).withVerb(null).withError(this.handle(ex));
    }

    public OAIPMH handle(OAIPMH oaipmh, RequestBuilder.RawRequest rawRequest) {
        Objects.requireNonNull(oaipmh);
        Objects.requireNonNull(rawRequest);
        if (rawRequest.hasErrors()) {
            oaipmh.withRequest(new Request(this.configuration.getBaseUrl())).withResponseDate(DateProvider.now()).withVerb(null);
            rawRequest.getErrors().forEach(ex -> oaipmh.withError(this.handle((OAIException)((Object)((Object)ex)))));
        }
        return oaipmh;
    }

    public Error handle(OAIException ex) {
        Objects.requireNonNull(ex);
        return new Error(ex.getMessage()).withCode(ex.getErrorCode());
    }
}

