/*
 * Decompiled with CFR 0.152.
 */
package io.gdcc.xoai.dataprovider;

import io.gdcc.xoai.dataprovider.handlers.ErrorHandler;
import io.gdcc.xoai.dataprovider.handlers.GetRecordHandler;
import io.gdcc.xoai.dataprovider.handlers.IdentifyHandler;
import io.gdcc.xoai.dataprovider.handlers.ListIdentifiersHandler;
import io.gdcc.xoai.dataprovider.handlers.ListMetadataFormatsHandler;
import io.gdcc.xoai.dataprovider.handlers.ListRecordsHandler;
import io.gdcc.xoai.dataprovider.handlers.ListSetsHandler;
import io.gdcc.xoai.dataprovider.model.Context;
import io.gdcc.xoai.dataprovider.repository.Repository;
import io.gdcc.xoai.dataprovider.repository.RepositoryConfiguration;
import io.gdcc.xoai.dataprovider.request.RequestBuilder;
import io.gdcc.xoai.exceptions.BadVerbException;
import io.gdcc.xoai.exceptions.OAIException;
import io.gdcc.xoai.model.oaipmh.OAIPMH;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.ResumptionToken;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.services.api.DateProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProvider {
    private static final Logger log = LoggerFactory.getLogger(DataProvider.class);
    private final RepositoryConfiguration configuration;
    protected final IdentifyHandler identifyHandler;
    protected final GetRecordHandler getRecordHandler;
    protected final ListSetsHandler listSetsHandler;
    protected final ListRecordsHandler listRecordsHandler;
    protected final ListIdentifiersHandler listIdentifiersHandler;
    protected final ListMetadataFormatsHandler listMetadataFormatsHandler;
    protected final ErrorHandler errorsHandler;

    public static DataProvider dataProvider(Context context, Repository repository) {
        return new DataProvider(context, repository);
    }

    public DataProvider(Context context, Repository repository) {
        Objects.requireNonNull(context, "Context for data provider may not be null");
        Objects.requireNonNull(repository, "Repository for data provider may not be null");
        Objects.requireNonNull(repository.getItemRepository(), "Repository must contain a non-null item repository");
        Objects.requireNonNull(repository.getSetRepository(), "Repository must contain a non-null sets repository");
        this.configuration = repository.getConfiguration();
        Objects.requireNonNull(this.configuration, "Repository configuration may not be null");
        this.identifyHandler = new IdentifyHandler(context, repository);
        this.listSetsHandler = new ListSetsHandler(context, repository);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(context, repository);
        this.listRecordsHandler = new ListRecordsHandler(context, repository);
        this.listIdentifiersHandler = new ListIdentifiersHandler(context, repository);
        this.getRecordHandler = new GetRecordHandler(context, repository);
        this.errorsHandler = new ErrorHandler(repository.getConfiguration());
    }

    public OAIPMH handle(Map<String, String[]> queryParameters) {
        OAIPMH oaipmh = new OAIPMH();
        try {
            RequestBuilder.RawRequest rawRequest = RequestBuilder.buildRawRequest(queryParameters);
            return this.handle(rawRequest);
        }
        catch (OAIException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return this.errorsHandler.handle(oaipmh, e);
        }
    }

    public OAIPMH handle(RequestBuilder.RawRequest rawRequest) {
        OAIPMH oaipmh = new OAIPMH();
        Request request = RequestBuilder.buildRequest(rawRequest, this.configuration);
        if (rawRequest.hasErrors()) {
            return this.errorsHandler.handle(oaipmh, rawRequest);
        }
        return this.handle(request);
    }

    public OAIPMH handle(Request request) {
        OAIPMH oaipmh = new OAIPMH().withRequest(request).withResponseDate(DateProvider.now());
        try {
            Optional clientSentToken = this.configuration.getResumptionTokenFormat().parse(request);
            ResumptionToken.Value token = clientSentToken.orElse(ResumptionToken.ValueBuilder.build((Request)request));
            Verb.Type verb = (Verb.Type)request.getType().orElseThrow(BadVerbException::new);
            switch (verb) {
                case Identify: {
                    return oaipmh.withVerb((Verb)this.identifyHandler.handle(request));
                }
                case ListSets: {
                    return oaipmh.withVerb((Verb)this.listSetsHandler.handle(token));
                }
                case ListMetadataFormats: {
                    return oaipmh.withVerb((Verb)this.listMetadataFormatsHandler.handle(request));
                }
                case GetRecord: {
                    return oaipmh.withVerb((Verb)this.getRecordHandler.handle(request));
                }
                case ListIdentifiers: {
                    return oaipmh.withVerb((Verb)this.listIdentifiersHandler.handle(token));
                }
                case ListRecords: {
                    return oaipmh.withVerb((Verb)this.listRecordsHandler.handle(token));
                }
            }
            throw new BadVerbException("Illegal verb " + verb);
        }
        catch (OAIException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return this.errorsHandler.handle(oaipmh, e);
        }
    }

    public static final String getOaiXSLT() {
        String string;
        block9: {
            ClassLoader classLoader = DataProvider.class.getClassLoader();
            URL oaiXsltResource = classLoader.getResource("oai2.xsl");
            if (oaiXsltResource == null) {
                log.warn("Could not find or load OAI XSLT file, class loader returned null");
                return "";
            }
            InputStream inStream = oaiXsltResource.openStream();
            try {
                string = new String(inStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Could not read OAI XSLT file", (Throwable)e);
                    return "";
                }
            }
            inStream.close();
        }
        return string;
    }
}

