/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Hex$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.check.ChecksumAlgorithm;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.impl.RequestTimeoutException;
import io.gatling.http.engine.GatlingHttpListener$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.response.ResponseBody$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.NotSslRecordException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tmu!B\u001c9\u0011\u0003\te!B\"9\u0011\u0003!\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0013A\u0006\"\u0002:\u0002\t\u0013\u0019h!B\"9\u0005\u0005e\u0001\u0002\u0003=\u0006\u0005\u0003\u0005\u000b\u0011B=\t\u0015\u0005MRA!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002F\u0015\u0011\t\u0011)A\u0005\u0003\u000fBa!V\u0003\u0005\u0002\u0005M\u0003\"CA/\u000b\u0001\u0007I\u0011BA0\u0011%\t9'\u0002a\u0001\n\u0013\tI\u0007\u0003\u0005\u0002p\u0015\u0001\u000b\u0015BA1\u0011%\t\t(\u0002a\u0001\n\u0013\t\u0019\bC\u0005\u0002|\u0015\u0001\r\u0011\"\u0003\u0002~!A\u0011\u0011Q\u0003!B\u0013\t)\bC\u0005\u0002\u0004\u0016\u0001\r\u0011\"\u0003\u0002t!I\u0011QQ\u0003A\u0002\u0013%\u0011q\u0011\u0005\t\u0003\u0017+\u0001\u0015)\u0003\u0002v!Y\u0011QR\u0003A\u0002\u0003\u0007I\u0011BA:\u0011-\ty)\u0002a\u0001\u0002\u0004%I!!%\t\u0017\u0005UU\u00011A\u0001B\u0003&\u0011Q\u000f\u0005\f\u0003/+\u0001\u0019!a\u0001\n\u0013\tI\nC\u0006\u0002\"\u0016\u0001\r\u00111A\u0005\n\u0005\r\u0006bCAT\u000b\u0001\u0007\t\u0011)Q\u0005\u00037C1\"!+\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\"Y\u00111V\u0003A\u0002\u0003\u0007I\u0011BAW\u0011-\t\t,\u0002a\u0001\u0002\u0003\u0006K!a'\t\u0017\u0005MV\u00011AA\u0002\u0013%\u00111\u000f\u0005\f\u0003k+\u0001\u0019!a\u0001\n\u0013\t9\fC\u0006\u0002<\u0016\u0001\r\u0011!Q!\n\u0005U\u0004bCA_\u000b\u0001\u0007\t\u0019!C\u0005\u0003\u007fC1\"a2\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u0002J\"Y\u0011QZ\u0003A\u0002\u0003\u0005\u000b\u0015BAa\u0011!!W\u00011A\u0005\n\u0005=\u0007\"CAi\u000b\u0001\u0007I\u0011BAj\u0011\u001d\t9.\u0002Q!\n\u0015D\u0011\"!7\u0006\u0001\u0004%I!a7\t\u0013\u0005\rX\u00011A\u0005\n\u0005\u0015\b\u0002CAu\u000b\u0001\u0006K!!8\t\u0013\u0005-X\u00011A\u0005\n\u00055\b\"\u0003B\u0001\u000b\u0001\u0007I\u0011\u0002B\u0002\u0011!\u00119!\u0002Q!\n\u0005=\b\"\u0003B\u0005\u000b\t\u0007I\u0011\u0002B\u0006\u0011!\u0011I$\u0002Q\u0001\n\t5\u0001b\u0002B\u001e\u000b\u0011\u0005#Q\b\u0005\b\u0005\u007f)A\u0011\tB!\u0011\u001d\u00119%\u0002C!\u0005\u0013BqA!\u0014\u0006\t\u0003\u0012y\u0005C\u0004\u0003V\u0015!\tEa\u0016\t\u000f\t\u0005T\u0001\"\u0003\u0003d!9!qN\u0003\u0005\n\tE\u0004b\u0002B8\u000b\u0011%!Q\u0010\u0005\b\u0005'+A\u0011\u0002B\u001f\u0011\u001d\u0011)*\u0002C!\u0005/\u000b1cR1uY&tw\r\u0013;ua2K7\u000f^3oKJT!!\u000f\u001e\u0002\r\u0015tw-\u001b8f\u0015\tYD(\u0001\u0003iiR\u0004(BA\u001f?\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aP\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002C\u00035\t\u0001HA\nHCRd\u0017N\\4IiR\u0004H*[:uK:,'oE\u0002\u0002\u000b.\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0007C\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0015A\u0004:fg>dg/Z\"iCJ\u001cX\r\u001e\u000b\u00043\u000e\u0004\bC\u0001.b\u001b\u0005Y&B\u0001/^\u0003\u001d\u0019\u0007.\u0019:tKRT!AX0\u0002\u00079LwNC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\t\\&aB\"iCJ\u001cX\r\u001e\u0005\u0006I\u000e\u0001\r!Z\u0001\bQ\u0016\fG-\u001a:t!\t1g.D\u0001h\u0015\tY\u0004N\u0003\u0002jU\u0006)1m\u001c3fG*\u00111\u000e\\\u0001\bQ\u0006tG\r\\3s\u0015\tig(A\u0003oKR$\u00180\u0003\u0002pO\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0011\u0015\t8\u00011\u0001Z\u00039!WMZ1vYR\u001c\u0005.\u0019:tKR\fq\u0002\\8h%\u0016\fX/Z:u\u0007J\f7\u000f\u001b\u000b\u0004i^t\bC\u0001$v\u0013\t1xI\u0001\u0003V]&$\b\"\u0002=\u0005\u0001\u0004I\u0018A\u0001;y!\tQH0D\u0001|\u0015\tA\b(\u0003\u0002~w\n1\u0001\n\u001e;q)bDaa \u0003A\u0002\u0005\u0005\u0011!\u0003;ie><\u0018M\u00197f!\u0011\t\u0019!a\u0005\u000f\t\u0005\u0015\u0011q\u0002\b\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002!\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015bAA\t\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000b\u0003/\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005EqiE\u0003\u0006\u00037\t9\u0003\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tcX\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\u0005}!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCO\u0001\u0007G2LWM\u001c;\n\t\u0005E\u00121\u0006\u0002\r\u0011R$\b\u000fT5ti\u0016tWM]\u0001\u0006G2|7m\u001b\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011)H/\u001b7\u000b\u0007\u0005}B(A\u0004d_6lwN\\:\n\t\u0005\r\u0013\u0011\b\u0002\u0006\u00072|7m[\u0001\u0012e\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014\b\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055\u0003(\u0001\u0005sKN\u0004xN\\:f\u0013\u0011\t\t&a\u0013\u0003#I+7\u000f]8og\u0016\u0004&o\\2fgN|'\u000f\u0006\u0005\u0002V\u0005]\u0013\u0011LA.!\t\u0011U\u0001C\u0003y\u0013\u0001\u0007\u0011\u0010C\u0004\u00024%\u0001\r!!\u000e\t\u000f\u0005\u0015\u0013\u00021\u0001\u0002H\u0005\u0011b-\u001b8bY\u000ec\u0017.\u001a8u%\u0016\fX/Z:u+\t\t\t\u0007\u0005\u0003\u0002*\u0005\r\u0014\u0002BA3\u0003W\u0011qAU3rk\u0016\u001cH/\u0001\fgS:\fGn\u00117jK:$(+Z9vKN$x\fJ3r)\r!\u00181\u000e\u0005\n\u0003[Z\u0011\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003M1\u0017N\\1m\u00072LWM\u001c;SKF,Xm\u001d;!\u0003\u0011Ig.\u001b;\u0016\u0005\u0005U\u0004c\u0001$\u0002x%\u0019\u0011\u0011P$\u0003\u000f\t{w\u000e\\3b]\u0006A\u0011N\\5u?\u0012*\u0017\u000fF\u0002u\u0003\u007fB\u0011\"!\u001c\u000f\u0003\u0003\u0005\r!!\u001e\u0002\u000b%t\u0017\u000e\u001e\u0011\u0002\t\u0011|g.Z\u0001\tI>tWm\u0018\u0013fcR\u0019A/!#\t\u0013\u00055\u0014#!AA\u0002\u0005U\u0014!\u00023p]\u0016\u0004\u0013AD:u_J,\u0007\n^7m\u001fJ\u001c5o]\u0001\u0013gR|'/\u001a%u[2|%oQ:t?\u0012*\u0017\u000fF\u0002u\u0003'C\u0011\"!\u001c\u0015\u0003\u0003\u0005\r!!\u001e\u0002\u001fM$xN]3Ii6dwJ]\"tg\u0002\nQC]3rk\u0016\u001cHo\u0015;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002\u001cB\u0019a)!(\n\u0007\u0005}uI\u0001\u0003M_:<\u0017!\u0007:fcV,7\u000f^*uCJ$H+[7fgR\fW\u000e]0%KF$2\u0001^AS\u0011%\tigFA\u0001\u0002\u0004\tY*\u0001\fsKF,Xm\u001d;Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!\u0003M\u0011X-];fgR,e\u000e\u001a+j[\u0016\u001cH/Y7q\u0003]\u0011X-];fgR,e\u000e\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000fF\u0002u\u0003_C\u0011\"!\u001c\u001b\u0003\u0003\u0005\r!a'\u0002)I,\u0017/^3ti\u0016sG\rV5nKN$\u0018-\u001c9!\u0003\u001dI7\u000f\u0013;uaJ\n1\"[:IiR\u0004(g\u0018\u0013fcR\u0019A/!/\t\u0013\u00055T$!AA\u0002\u0005U\u0014\u0001C5t\u0011R$\bO\r\u0011\u0002\rM$\u0018\r^;t+\t\t\t\rE\u0002g\u0003\u0007L1!!2h\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u0002\u0015M$\u0018\r^;t?\u0012*\u0017\u000fF\u0002u\u0003\u0017D\u0011\"!\u001c!\u0003\u0003\u0005\r!!1\u0002\u000fM$\u0018\r^;tAU\tQ-A\u0006iK\u0006$WM]:`I\u0015\fHc\u0001;\u0002V\"A\u0011QN\u0012\u0002\u0002\u0003\u0007Q-\u0001\u0005iK\u0006$WM]:!\u0003)\u0011w\u000eZ=MK:<G\u000f[\u000b\u0003\u0003;\u00042ARAp\u0013\r\t\to\u0012\u0002\u0004\u0013:$\u0018A\u00042pIfdUM\\4uQ~#S-\u001d\u000b\u0004i\u0006\u001d\b\"CA7M\u0005\u0005\t\u0019AAo\u0003-\u0011w\u000eZ=MK:<G\u000f\u001b\u0011\u0002\r\rDWO\\6t+\t\ty\u000f\u0005\u0004\u0002\u0004\u0005E\u0018Q_\u0005\u0005\u0003g\f9B\u0001\u0003MSN$\b\u0003BA|\u0003{l!!!?\u000b\u0007\u0005mH.\u0001\u0004ck\u001a4WM]\u0005\u0005\u0003\u007f\fIPA\u0004CsR,')\u001e4\u0002\u0015\rDWO\\6t?\u0012*\u0017\u000fF\u0002u\u0005\u000bA\u0011\"!\u001c*\u0003\u0003\u0005\r!a<\u0002\u000f\rDWO\\6tA\u00059A-[4fgR\u001cXC\u0001B\u0007!!\u0011yA!\u0007\u0003\u001e\t5RB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0013%lW.\u001e;bE2,'b\u0001B\f\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\u0006G\",7m\u001b\u0006\u0004\u0005Oa\u0014\u0001B2pe\u0016LAAa\u000b\u0003\"\t\t2\t[3dWN,X.\u00117h_JLG\u000f[7\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\r`\u0003!\u0019XmY;sSRL\u0018\u0002\u0002B\u001c\u0005c\u0011Q\"T3tg\u0006<W\rR5hKN$\u0018\u0001\u00033jO\u0016\u001cHo\u001d\u0011\u0002\r=t7+\u001a8e)\u0005!\u0018\u0001F8o\r&t\u0017\r\\\"mS\u0016tGOU3rk\u0016\u001cH\u000fF\u0002u\u0005\u0007BqA!\u0012/\u0001\u0004\t\t'A\u0004sKF,Xm\u001d;\u0002'=t\u0007K]8u_\u000e|G.Q<be\u0016tWm]:\u0015\u0007Q\u0014Y\u0005C\u0004\u00024>\u0002\r!!\u001e\u0002\u001d=t\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tKR)AO!\u0015\u0003T!9\u0011Q\u0018\u0019A\u0002\u0005\u0005\u0007\"\u000231\u0001\u0004)\u0017aF8o\u0011R$\bOU3ta>t7/\u001a\"pIf\u001c\u0005.\u001e8l)\u0015!(\u0011\fB/\u0011\u001d\u0011Y&\ra\u0001\u0003k\fQa\u00195v].DqAa\u00182\u0001\u0004\t)(\u0001\u0003mCN$\u0018!\u00042vS2$'+Z:q_:\u001cX-\u0006\u0002\u0003fA!!q\rB6\u001b\t\u0011IGC\u0002\u0002NiJAA!\u001c\u0003j\tQ\u0001\n\u001e;q%\u0016\u001cX\u000f\u001c;\u0002\u0019\t,\u0018\u000e\u001c3GC&dWO]3\u0015\t\tM$\u0011\u0010\t\u0005\u0005O\u0012)(\u0003\u0003\u0003x\t%$a\u0003%uiB4\u0015-\u001b7ve\u0016DqAa\u001f4\u0001\u0004\t\t!A\u0001u)\u0011\u0011\u0019Ha \t\u000f\t\u0005E\u00071\u0001\u0003\u0004\u0006aQM\u001d:pe6+7o]1hKB!!Q\u0011BG\u001d\u0011\u00119I!#\u0011\u0007\u0005\u001dq)C\u0002\u0003\f\u001e\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002BH\u0005#\u0013aa\u0015;sS:<'b\u0001BF\u000f\u0006i!/\u001a7fCN,7\t[;oWN\f1b\u001c8UQJ|w/\u00192mKR\u0019AO!'\t\r}4\u0004\u0019AA\u0001\u0001")
public final class GatlingHttpListener
implements HttpListener {
    private final HttpTx tx;
    private final Clock clock;
    private final ResponseProcessor responseProcessor;
    private Request finalClientRequest;
    private boolean init;
    private boolean done;
    private boolean storeHtmlOrCss;
    private long requestStartTimestamp;
    private long requestEndTimestamp;
    private boolean isHttp2;
    private HttpResponseStatus status;
    private HttpHeaders headers;
    private int bodyLength;
    private List<ByteBuf> chunks;
    private final Map<ChecksumAlgorithm, MessageDigest> digests;

    public void onWrite(Channel x$1) {
        super.onWrite(x$1);
    }

    private Request finalClientRequest() {
        return this.finalClientRequest;
    }

    private void finalClientRequest_$eq(Request x$1) {
        this.finalClientRequest = x$1;
    }

    private boolean init() {
        return this.init;
    }

    private void init_$eq(boolean x$1) {
        this.init = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    private void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    private long requestStartTimestamp() {
        return this.requestStartTimestamp;
    }

    private void requestStartTimestamp_$eq(long x$1) {
        this.requestStartTimestamp = x$1;
    }

    private long requestEndTimestamp() {
        return this.requestEndTimestamp;
    }

    private void requestEndTimestamp_$eq(long x$1) {
        this.requestEndTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private HttpResponseStatus status() {
        return this.status;
    }

    private void status_$eq(HttpResponseStatus x$1) {
        this.status = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private int bodyLength() {
        return this.bodyLength;
    }

    private void bodyLength_$eq(int x$1) {
        this.bodyLength = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    private Map<ChecksumAlgorithm, MessageDigest> digests() {
        return this.digests;
    }

    public void onSend() {
        if (!this.init()) {
            this.init_$eq(true);
            this.requestStartTimestamp_$eq(this.clock.nowMillis());
            return;
        }
    }

    public void onFinalClientRequest(Request request) {
        this.finalClientRequest_$eq(request);
    }

    public void onProtocolAwareness(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        if (!this.done()) {
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            this.status_$eq(status);
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.tx.request().requestConfig().httpProtocol().responsePart().inferHtmlResources() && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
            return;
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        if (!this.done()) {
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            int chunkLength = chunk.readableBytes();
            if (chunkLength > 0) {
                this.bodyLength_$eq(this.bodyLength() + chunkLength);
                if (this.tx.request().requestConfig().storeBodyParts() || this.storeHtmlOrCss()) {
                    ByteBuf byteBuf = chunk.retain();
                    this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf));
                }
                if (this.digests().nonEmpty()) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])chunk.nioBuffers()), (Function1 & Serializable)nioBuffer -> {
                        GatlingHttpListener.$anonfun$onHttpResponseBodyChunk$1(this, nioBuffer);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (last) {
                this.done_$eq(true);
                try {
                    this.responseProcessor.onComplete(this.buildResponse());
                }
                finally {
                    this.releaseChunks();
                }
                return;
            }
            return;
        }
    }

    private HttpResult buildResponse() {
        Product product;
        if (this.status() == null) {
            return this.buildFailure("How come we're trying to build a response with no status?!");
        }
        try {
            this.requestEndTimestamp_$eq(package$.MODULE$.max(this.requestEndTimestamp(), this.requestStartTimestamp()));
            Map checksums = (Map)this.digests().view().mapValues((Function1 & Serializable)md -> Hex$.MODULE$.toHexString(md.digest())).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
            List chunksOrderedByArrival = this.chunks().reverse();
            ResponseBody body = ResponseBody$.MODULE$.apply(this.bodyLength(), (List<ByteBuf>)chunksOrderedByArrival, GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$resolveCharset(this.headers(), this.tx.request().requestConfig().defaultCharset()));
            product = new Response(this.finalClientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), this.status(), this.headers(), body, (Map<ChecksumAlgorithm, String>)checksums, this.isHttp2());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                product = this.buildFailure(throwable2);
            }
            throw throwable;
        }
        return product;
    }

    private HttpFailure buildFailure(Throwable t) {
        Throwable rootCause = Throwables.PimpedException$.MODULE$.rootCause$extension(Throwables$.MODULE$.PimpedException(t));
        Class<?> rootCauseClass = rootCause.getClass();
        String message = rootCauseClass == NotSslRecordException.class ? "i.n.h.s.NotSslRecordException" : (rootCauseClass == RequestTimeoutException.class ? rootCause.getMessage() : Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(rootCause)));
        return this.buildFailure(message);
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.finalClientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), errorMessage);
    }

    private void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public void onThrowable(Throwable throwable) {
        if (!this.done()) {
            this.done_$eq(true);
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$logRequestCrash(this.tx, throwable);
            try {
                this.responseProcessor.onComplete(this.buildFailure(throwable));
            }
            finally {
                this.releaseChunks();
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onHttpResponseBodyChunk$1(GatlingHttpListener $this, ByteBuffer nioBuffer) {
        $this.digests().values().foreach((Function1 & Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public GatlingHttpListener(HttpTx tx, Clock clock, ResponseProcessor responseProcessor) {
        this.tx = tx;
        this.clock = clock;
        this.responseProcessor = responseProcessor;
        this.finalClientRequest = tx.request().clientRequest();
        this.init = false;
        this.done = false;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.bodyLength = 0;
        this.chunks = Nil$.MODULE$;
        this.digests = tx.request().requestConfig().checksumAlgorithms().map((Function1 & Serializable)algorithm -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(algorithm), (Object)algorithm.digest())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

