/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.cli;

import io.gatling.plugin.ConfigurationConstants;
import java.io.File;
import java.nio.file.Paths;

public class EnterpriseDeployOptions {
    public final File baseDirectory;
    public final String packageDescriptorFilename;
    public final File packageFile;
    public final String artifactId;

    public EnterpriseDeployOptions() {
        String string = ConfigurationConstants.DeployOptions.BaseDirectory.value();
        if (string != null) {
            this.baseDirectory = Paths.get(string, new String[0]).toFile();
            if (!this.baseDirectory.isDirectory()) {
                throw new IllegalArgumentException("Base directory is not a directory: " + String.valueOf(this.baseDirectory));
            }
        } else {
            throw new IllegalArgumentException("Base directory is not defined");
        }
        this.packageDescriptorFilename = ConfigurationConstants.DeployOptions.PackageDescriptorFilename.value();
        String string2 = ConfigurationConstants.DeployOptions.PackageFile.value();
        if (string2 != null) {
            this.packageFile = Paths.get(string2, new String[0]).toFile();
            if (!this.packageFile.exists()) {
                throw new IllegalArgumentException("Package file does not exists: " + this.packageFile.getAbsolutePath());
            }
        } else {
            throw new IllegalArgumentException("Package file is not defined");
        }
        this.artifactId = ConfigurationConstants.DeployOptions.ArtifactId.value();
    }
}

