/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.pem.domain.PEM;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;

public class RSAVerifier
implements Verifier {
    private final RSAPublicKey publicKey;

    private RSAVerifier(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [RSAPublicKey], but found [" + publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (RSAPublicKey)publicKey;
        this.assertValidKeyLength();
    }

    private RSAVerifier(String publicKey) {
        Objects.requireNonNull(publicKey);
        PEM pem = PEM.decode(publicKey);
        if (pem.publicKey == null) {
            throw new MissingPublicKeyException("The provided PEM encoded string did not contain a public key.");
        }
        if (!(pem.publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [RSAPublicKey], but found [" + pem.publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (RSAPublicKey)pem.getPublicKey();
        this.assertValidKeyLength();
    }

    public static RSAVerifier newVerifier(PublicKey publicKey) {
        return new RSAVerifier(publicKey);
    }

    public static RSAVerifier newVerifier(String publicKey) {
        return new RSAVerifier(publicKey);
    }

    public static RSAVerifier newVerifier(Path path) {
        Objects.requireNonNull(path);
        try {
            return new RSAVerifier(new String(Files.readAllBytes(path)));
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + String.valueOf(path.toAbsolutePath()) + "]", e);
        }
    }

    public static RSAVerifier newVerifier(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new RSAVerifier(new String(bytes));
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        return switch (algorithm) {
            case Algorithm.RS256, Algorithm.RS384, Algorithm.RS512 -> true;
            default -> false;
        };
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Signature verifier = Signature.getInstance(algorithm.getName());
            verifier.initVerify(this.publicKey);
            verifier.update(message);
            if (!verifier.verify(signature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (SecurityException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }

    private void assertValidKeyLength() {
        int keyLength = this.publicKey.getModulus().bitLength();
        if (keyLength < 2047) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }
}

