/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.jwt.domain.Algorithm;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class ECDSASignature {
    private final byte[] bytes;

    public ECDSASignature(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] derDecode(Algorithm algorithm) throws IOException {
        DerValue[] sequence = new DerInputStream(this.bytes).getSequence();
        byte[] r = sequence[0].getPositiveBigInteger().toByteArray();
        byte[] s = sequence[1].getPositiveBigInteger().toByteArray();
        byte[] result = switch (algorithm) {
            case Algorithm.ES256 -> new byte[64];
            case Algorithm.ES384 -> new byte[96];
            case Algorithm.ES512 -> new byte[132];
            default -> throw new IllegalArgumentException("Unable to decode the signature for algorithm [" + algorithm.name() + "]");
        };
        int componentLength = result.length / 2;
        int rSrcPos = r.length > componentLength ? r.length - componentLength : 0;
        int rDstPos = Math.max(0, componentLength - r.length);
        int rLength = Math.min(r.length, componentLength);
        System.arraycopy(r, rSrcPos, result, rDstPos, rLength);
        int sSrcPos = s.length > componentLength ? s.length - componentLength : 0;
        int sDstPos = s.length < componentLength ? componentLength + (componentLength - s.length) : componentLength;
        int sLength = Math.min(s.length, componentLength);
        System.arraycopy(s, sSrcPos, result, sDstPos, sLength);
        return result;
    }

    public byte[] derEncode() throws IOException {
        byte[] r = Arrays.copyOfRange(this.bytes, 0, this.bytes.length / 2);
        byte[] s = Arrays.copyOfRange(this.bytes, this.bytes.length / 2, this.bytes.length);
        return new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(new BigInteger(1, r))).writeValue(new DerValue(new BigInteger(1, s))))).toByteArray();
    }
}

