/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.domain.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class OpenIDConnect {
    public static String at_hash(String accessToken, Algorithm algorithm) {
        return OpenIDConnect.generate_hash(accessToken, algorithm);
    }

    public static String c_hash(String authorizationCode, Algorithm algorithm) {
        return OpenIDConnect.generate_hash(authorizationCode, algorithm);
    }

    private static String generate_hash(String string, Algorithm algorithm) {
        MessageDigest messageDigest;
        Objects.requireNonNull(string);
        Objects.requireNonNull(algorithm);
        int leftMostBits = switch (algorithm) {
            case Algorithm.ES256, Algorithm.HS256, Algorithm.RS256 -> {
                messageDigest = OpenIDConnect.getDigest("SHA-256");
                yield 128;
            }
            case Algorithm.ES384, Algorithm.HS384, Algorithm.RS384 -> {
                messageDigest = OpenIDConnect.getDigest("SHA-384");
                yield 192;
            }
            case Algorithm.Ed25519, Algorithm.ES512, Algorithm.HS512, Algorithm.RS512 -> {
                messageDigest = OpenIDConnect.getDigest("SHA-512");
                yield 256;
            }
            case Algorithm.Ed448 -> {
                messageDigest = OpenIDConnect.getDigest("SHAKE256");
                yield 456;
            }
            default -> throw new IllegalArgumentException("You specified an unsupported algorithm. The algorithm [" + String.valueOf((Object)algorithm) + "] is not supported. You must use Ed25519, Ed448, ES256, ES384, ES512,  HS256, HS384, HS512, RS256, RS384 or RS512.");
        };
        byte[] digest = string.getBytes(StandardCharsets.UTF_8);
        digest = messageDigest.digest(digest);
        int toIndex = Math.min(digest.length, leftMostBits / 8);
        byte[] leftMostBytes = Arrays.copyOfRange(digest, 0, toIndex);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(leftMostBytes));
    }

    private static MessageDigest getDigest(String digest) {
        try {
            return MessageDigest.getInstance(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

