/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerDecodingException;
import io.fusionauth.domain.Buildable;
import java.util.Arrays;
import java.util.Objects;

public class ObjectIdentifier
implements Buildable<ObjectIdentifier> {
    public static final String ECDSA_P256 = "1.2.840.10045.3.1.7";
    public static final String ECDSA_P384 = "1.3.132.0.34";
    public static final String ECDSA_P521 = "1.3.132.0.35";
    public static final String EC_ENCRYPTION = "1.2.840.10045.2.1";
    public static final String EdDSA_25519 = "1.3.101.112";
    public static final String EdDSA_448 = "1.3.101.113";
    public static final String RSA_ENCRYPTION = "1.2.840.113549.1.1.1";
    public static final String RSASSA_PSS_ENCRYPTION = "1.2.840.113549.1.1.10";
    public static final String RSA_SHA256 = "1.2.840.113549.1.1.11";
    public static final String RSA_SHA384 = "1.2.840.113549.1.1.12";
    public static final String RSA_SHA512 = "1.2.840.113549.1.1.13";
    public static final String SHA256 = "2.16.840.1.101.3.4.2.1";
    public static final String SHA384 = "2.16.840.1.101.3.4.2.2";
    public static final String SHA512 = "2.16.840.1.101.3.4.2.3";
    public byte[] value;
    private String decoded;

    public ObjectIdentifier(byte[] value) {
        this.value = value;
    }

    public String decode() throws DerDecodingException {
        if (this.decoded == null) {
            this._decode();
        }
        return this.decoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier that = (ObjectIdentifier)o;
        return Arrays.equals(this.value, that.value) && Objects.equals(this.decoded, that.decoded);
    }

    public int hashCode() {
        int result = Objects.hash(this.decoded);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        try {
            return this.decode();
        }
        catch (DerDecodingException e) {
            return "Failed to _decode this object, unable to produce a string.";
        }
    }

    private void _decode() throws DerDecodingException {
        StringBuilder sb = new StringBuilder(this.value.length * 4);
        int index = 0;
        for (int i = 0; i < this.value.length; ++i) {
            if (i - index + 1 > 4) {
                throw new DerDecodingException("The object identifier contains a node that is larger than 4 bytes. This is not currently supported using this library.");
            }
            byte b = this.value[i];
            if ((b & 0x80) != 0) continue;
            if (index != 0) {
                sb.append('.');
            }
            int node = 0;
            for (int j = index; j <= i; ++j) {
                node <<= 7;
                node |= this.value[j] & 0x7F;
            }
            if (index == 0) {
                if (node < 80) {
                    sb.append(node / 40).append('.').append(node % 40);
                } else {
                    sb.append("2.").append(node - 80);
                }
            } else {
                sb.append(node);
            }
            index = i + 1;
        }
        this.decoded = sb.toString();
    }
}

