/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.oauth2;

import io.fusionauth.http.AbstractHttpHelper;
import io.fusionauth.jwt.json.Mapper;
import io.fusionauth.oauth2.domain.AuthorizationServerMetaData;
import java.net.HttpURLConnection;
import java.util.Objects;

public class ServerMetaDataHelper
extends AbstractHttpHelper {
    public static AuthorizationServerMetaData retrieveFromIssuer(String issuer) {
        Objects.requireNonNull(issuer);
        if (issuer.endsWith("/")) {
            issuer = issuer.substring(0, issuer.length() - 1);
        }
        return ServerMetaDataHelper.retrieveFromWellKnownConfiguration(issuer + "/.well-known/oauth-authorization-server");
    }

    public static AuthorizationServerMetaData retrieveFromWellKnownConfiguration(HttpURLConnection httpURLConnection) {
        return ServerMetaDataHelper.get(httpURLConnection, is -> Mapper.deserialize(is, AuthorizationServerMetaData.class), ServerMetaDataException::new);
    }

    public static AuthorizationServerMetaData retrieveFromWellKnownConfiguration(String endpoint) {
        return ServerMetaDataHelper.retrieveFromWellKnownConfiguration(ServerMetaDataHelper.buildURLConnection(endpoint));
    }

    public static class ServerMetaDataException
    extends RuntimeException {
        public ServerMetaDataException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

