/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ec.ECDSASignature;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.Objects;

public class ECVerifier
implements Verifier {
    private final ECPublicKey publicKey;
    private final CryptoProvider cryptoProvider;

    private ECVerifier(PublicKey publicKey, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [ECPublicKey], but found [" + publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (ECPublicKey)publicKey;
    }

    private ECVerifier(String publicKey, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        PEM pem = PEM.decode(publicKey);
        if (pem.publicKey == null) {
            throw new MissingPublicKeyException("The provided PEM encoded string did not contain a public key.");
        }
        if (!(pem.publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [ECPublicKey], but found [" + pem.publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (ECPublicKey)pem.getPublicKey();
    }

    public static ECVerifier newVerifier(String publicKey) {
        return new ECVerifier(publicKey, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECVerifier newVerifier(PublicKey publicKey) {
        return new ECVerifier(publicKey, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECVerifier newVerifier(Path path) {
        return ECVerifier.newVerifier(path, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECVerifier newVerifier(byte[] bytes) {
        return ECVerifier.newVerifier(bytes, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECVerifier newVerifier(String publicKey, CryptoProvider cryptoProvider) {
        return new ECVerifier(publicKey, cryptoProvider);
    }

    public static ECVerifier newVerifier(PublicKey publicKey, CryptoProvider cryptoProvider) {
        return new ECVerifier(publicKey, cryptoProvider);
    }

    public static ECVerifier newVerifier(Path path, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(path);
        try {
            return new ECVerifier(new String(Files.readAllBytes(path)), cryptoProvider);
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + path.toAbsolutePath().toString() + "]", e);
        }
    }

    public static ECVerifier newVerifier(byte[] bytes, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(bytes);
        return new ECVerifier(new String(bytes), cryptoProvider);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case ES256: 
            case ES384: 
            case ES512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Signature verifier = this.cryptoProvider.getSignatureInstance(algorithm.getName());
            verifier.initVerify(this.publicKey);
            verifier.update(message);
            byte[] derEncoded = new ECDSASignature(signature).derEncode();
            if (!verifier.verify(derEncoded)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (IOException | SecurityException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }
}

