/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.HexUtils;
import io.fusionauth.jwt.InvalidJWTException;
import io.fusionauth.jwt.domain.Header;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.domain.KeyPair;
import io.fusionauth.jwt.domain.KeyType;
import io.fusionauth.jwt.json.Mapper;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Objects;

public class JWTUtils {
    public static String convertFingerprintToThumbprint(String fingerprint) {
        byte[] bytes = HexUtils.toBytes(fingerprint);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    public static String convertThumbprintToFingerprint(String x5tHash) {
        byte[] bytes = Base64.getUrlDecoder().decode(x5tHash.getBytes(StandardCharsets.UTF_8));
        return HexUtils.fromBytes(bytes);
    }

    public static Header decodeHeader(String encodedJWT) {
        Objects.requireNonNull(encodedJWT);
        String[] parts = encodedJWT.split("\\.");
        if (parts.length == 3 || parts.length == 2 && encodedJWT.endsWith(".")) {
            return Mapper.deserialize(Base64.getUrlDecoder().decode(parts[0]), Header.class);
        }
        throw new InvalidJWTException("The encoded JWT is not properly formatted. Expected a three part dot separated string.");
    }

    public static JWT decodePayload(String encodedJWT) {
        Objects.requireNonNull(encodedJWT);
        String[] parts = encodedJWT.split("\\.");
        if (parts.length == 3 || parts.length == 2 && encodedJWT.endsWith(".")) {
            return Mapper.deserialize(Base64.getUrlDecoder().decode(parts[1]), JWT.class);
        }
        throw new InvalidJWTException("The encoded JWT is not properly formatted. Expected a three part dot separated string.");
    }

    public static KeyPair generate2048_RSAKeyPair() {
        return JWTUtils.generateKeyPair(2048, KeyType.RSA);
    }

    public static KeyPair generate256_ECKeyPair() {
        return JWTUtils.generateKeyPair(256, KeyType.EC);
    }

    public static KeyPair generate3072_RSAKeyPair() {
        return JWTUtils.generateKeyPair(3072, KeyType.RSA);
    }

    public static KeyPair generate384_ECKeyPair() {
        return JWTUtils.generateKeyPair(384, KeyType.EC);
    }

    public static KeyPair generate4096_RSAKeyPair() {
        return JWTUtils.generateKeyPair(4096, KeyType.RSA);
    }

    public static KeyPair generate521_ECKeyPair() {
        return JWTUtils.generateKeyPair(521, KeyType.EC);
    }

    public static String generateJWS_kid(String algorithm, JSONWebKey key) {
        LinkedHashMap<String, Object> thumbPrint = new LinkedHashMap<String, Object>(4);
        if (key.kty == KeyType.EC) {
            thumbPrint.put("crv", key.crv);
            thumbPrint.put("kty", (Object)key.kty);
            thumbPrint.put("x", key.x);
            thumbPrint.put("y", key.y);
        } else {
            thumbPrint.put("e", key.e);
            thumbPrint.put("kty", (Object)key.kty);
            thumbPrint.put("n", key.n);
        }
        return JWTUtils.digest(algorithm, Mapper.serialize(thumbPrint));
    }

    public static String generateJWS_kid(JSONWebKey key) {
        return JWTUtils.generateJWS_kid("SHA-1", key);
    }

    public static String generateJWS_kid_S256(JSONWebKey key) {
        return JWTUtils.generateJWS_kid("SHA-256", key);
    }

    public static String generateJWS_x5t(String algorithm, String encodedCertificate) {
        byte[] bytes = Base64.getDecoder().decode(encodedCertificate.getBytes(StandardCharsets.UTF_8));
        return JWTUtils.digest(algorithm, bytes);
    }

    public static String generateJWS_x5t(String encodedCertificate) {
        return JWTUtils.generateJWS_x5t("SHA-1", encodedCertificate);
    }

    public static String generateJWS_x5t(String algorithm, byte[] derEncodedCertificate) {
        return JWTUtils.digest(algorithm, derEncodedCertificate);
    }

    public static String generateJWS_x5t(byte[] derEncodedCertificate) {
        return JWTUtils.digest("SHA-1", derEncodedCertificate);
    }

    public static String generateSHA256_HMACSecret() {
        return JWTUtils.generateSecureRandom(32);
    }

    public static String generateSHA384_HMACSecret() {
        return JWTUtils.generateSecureRandom(48);
    }

    public static String generateSHA512_HMACSecret() {
        return JWTUtils.generateSecureRandom(64);
    }

    public static String generateSecureRandom(int bytes) {
        byte[] buffer = new byte[bytes];
        new SecureRandom().nextBytes(buffer);
        return Base64.getEncoder().encodeToString(buffer);
    }

    private static String digest(String algorithm, byte[] bytes) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm [" + algorithm + "]");
        }
        byte[] digest = messageDigest.digest(bytes);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(digest));
    }

    private static KeyPair generateKeyPair(int keySize, KeyType keyType) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyType.name());
            keyPairGenerator.initialize(keySize);
            java.security.KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String privateKey = PEM.encode(keyPair.getPrivate(), keyPair.getPublic());
            String publicKey = PEM.encode(keyPair.getPublic());
            return new KeyPair(privateKey, publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

