/*
 * Copyright (c) 2016, FusionAuth, All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */

package io.fusionauth.jwt;

/**
 * The JWT Signer or Verifier is attempting to utilize an RSA Key Length of less than 2048.
 *
 * @author Daniel DeGroff
 */
public class InvalidKeyLengthException extends JWTException {
  public InvalidKeyLengthException(String message) {
    super(message);
  }
}
