/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class Header {
    @JsonProperty(value="alg")
    public Algorithm algorithm;
    @JsonIgnore
    public Map<String, String> properties = new LinkedHashMap<String, String>();
    @JsonProperty(value="typ")
    public Type type = Type.JWT;

    public Header() {
    }

    public Header(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @JsonAnyGetter
    public Map<String, String> anyGetter() {
        return this.properties;
    }

    public String get(String name) {
        return this.properties.get(name);
    }

    @JsonAnySetter
    public Header set(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.properties.put(name, value);
        return this;
    }
}

