/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Header;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.json.Mapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class JWTEncoder {
    private static JWTEncoder instance;

    public static JWTEncoder getInstance() {
        if (instance == null) {
            instance = new JWTEncoder();
        }
        return instance;
    }

    public String encode(JWT jwt, Signer signer) {
        return this.encode(jwt, signer, null);
    }

    public String encode(JWT jwt, Signer signer, Consumer<Header> consumer) {
        Objects.requireNonNull(jwt);
        Objects.requireNonNull(signer);
        ArrayList<String> parts = new ArrayList<String>(3);
        Header header = new Header();
        if (consumer != null) {
            consumer.accept(header);
        }
        header.algorithm = signer.getAlgorithm();
        parts.add(this.base64Encode(Mapper.serialize(header)));
        parts.add(this.base64Encode(Mapper.serialize(jwt)));
        byte[] signature = signer.sign(this.join(parts));
        parts.add(this.base64Encode(signature));
        return this.join(parts);
    }

    private String base64Encode(byte[] bytes) {
        return new String(Base64.getUrlEncoder().withoutPadding().encode(bytes));
    }

    private String join(Collection<String> collection) {
        return collection.stream().collect(Collectors.joining("."));
    }
}

