/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jsass;

import com.google.gson.Gson;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import io.bit3.jsass.annotation.DebugFunction;
import io.bit3.jsass.annotation.ErrorFunction;
import io.bit3.jsass.annotation.WarnFunction;
import io.bit3.jsass.importer.Importer;
import io.freefair.gradle.plugins.jsass.SassError;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@Deprecated
public class SassCompile
extends SourceTask {
    @Internal
    private final DirectoryProperty destinationDir = this.getProject().getObjects().directoryProperty();
    @Input
    @Optional
    private List<Object> functionProviders = new LinkedList<Object>();
    @Input
    @Optional
    private List<Importer> headerImporters = new LinkedList<Importer>();
    @Input
    @Optional
    private Collection<Importer> importers = new LinkedList<Importer>();
    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    private final ConfigurableFileCollection includePaths = this.getProject().files(new Object[0]);
    @Input
    private final Property<String> indent = this.getProject().getObjects().property(String.class);
    @Input
    private final Property<String> linefeed = this.getProject().getObjects().property(String.class);
    @Input
    private final Property<Boolean> omitSourceMapUrl = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<OutputStyle> outputStyle = this.getProject().getObjects().property(OutputStyle.class);
    @Input
    @Optional
    private final Property<String> pluginPath = this.getProject().getObjects().property(String.class);
    @Input
    private final Property<Integer> precision = this.getProject().getObjects().property(Integer.class);
    @Input
    private final Property<Boolean> sourceComments = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<Boolean> sourceMapContents = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<Boolean> sourceMapEmbed = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<Boolean> sourceMapEnabled = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    private final Property<URI> sourceMapRoot = this.getProject().getObjects().property(URI.class);

    public SassCompile() {
        this.include(new String[]{"**/*.scss"});
        this.include(new String[]{"**/*.sass"});
        ExtraPropertiesExtension extraProperties = new DslObject((Object)this).getExtensions().getExtraProperties();
        for (OutputStyle value : OutputStyle.values()) {
            extraProperties.set(value.name(), (Object)value);
        }
    }

    @OutputFiles
    protected FileTree getOutputFiles() {
        ConfigurableFileTree files = this.getProject().fileTree((Object)this.destinationDir);
        files.include(new String[]{"**/*.css"});
        files.include(new String[]{"**/*.css.map"});
        return files;
    }

    @TaskAction
    public void compileSass() {
        final Compiler compiler = new Compiler();
        final Options options = new Options();
        options.setFunctionProviders(new ArrayList<Object>(this.getFunctionProviders()));
        options.getFunctionProviders().add(new LoggingFunctionProvider());
        options.setHeaderImporters(this.getHeaderImporters());
        options.setImporters(this.getImporters());
        if (this.getIncludePaths() != null) {
            options.setIncludePaths(new ArrayList(this.getIncludePaths().getFiles()));
        }
        options.setIndent((String)this.indent.get());
        options.setLinefeed((String)this.linefeed.get());
        options.setOmitSourceMapUrl(((Boolean)this.omitSourceMapUrl.get()).booleanValue());
        options.setOutputStyle((OutputStyle)this.outputStyle.get());
        options.setPluginPath((String)this.pluginPath.getOrNull());
        options.setPrecision(((Integer)this.precision.get()).intValue());
        options.setSourceComments(((Boolean)this.sourceComments.get()).booleanValue());
        options.setSourceMapContents(((Boolean)this.sourceMapContents.get()).booleanValue());
        options.setSourceMapEmbed(((Boolean)this.sourceMapEmbed.get()).booleanValue());
        options.setSourceMapRoot((URI)this.sourceMapRoot.getOrNull());
        this.getSource().visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                block9: {
                    String name = fileVisitDetails.getName();
                    if (name.startsWith("_")) {
                        return;
                    }
                    if (name.endsWith(".scss") || name.endsWith(".sass")) {
                        File in = fileVisitDetails.getFile();
                        String pathString = fileVisitDetails.getRelativePath().getPathString();
                        pathString = pathString.substring(0, pathString.length() - 5) + ".css";
                        File realOut = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString);
                        File fakeOut = new File(fileVisitDetails.getFile().getParentFile(), name.substring(0, name.length() - 5) + ".css");
                        File realMap = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString + ".map");
                        File fakeMap = new File(fakeOut.getPath() + ".map");
                        options.setIsIndentedSyntaxSrc(name.endsWith(".sass"));
                        if (((Boolean)SassCompile.this.sourceMapEnabled.get()).booleanValue()) {
                            options.setSourceMapFile(fakeMap.toURI());
                        } else {
                            options.setSourceMapFile(null);
                        }
                        try {
                            URI inputPath = in.getAbsoluteFile().toURI();
                            Output output = compiler.compileFile(inputPath, fakeOut.toURI(), options);
                            if (!realOut.getParentFile().exists() && !realOut.getParentFile().mkdirs()) {
                                SassCompile.this.getLogger().error("Cannot write into {}", (Object)realOut.getParentFile());
                                throw new GradleException("Cannot write into " + realMap.getParentFile());
                            }
                            Files.write(realOut.toPath(), output.getCss().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                            if (!((Boolean)SassCompile.this.sourceMapEnabled.get()).booleanValue()) break block9;
                            if (realMap.getParentFile().exists() || realMap.getParentFile().mkdirs()) {
                                Files.write(realMap.toPath(), output.getSourceMap().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                break block9;
                            }
                            SassCompile.this.getLogger().error("Cannot write into {}", (Object)realMap.getParentFile());
                            throw new GradleException("Cannot write into " + realMap.getParentFile());
                        }
                        catch (CompilationException e) {
                            SassError sassError = (SassError)new Gson().fromJson(e.getErrorJson(), SassError.class);
                            SassCompile.this.getLogger().error("{}:{}:{}", new Object[]{sassError.getFile(), sassError.getLine(), sassError.getColumn()});
                            SassCompile.this.getLogger().error(e.getErrorMessage());
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            SassCompile.this.getLogger().error(e.getLocalizedMessage());
                            throw new UncheckedIOException((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public void setOutputStyle(String outputStyle) {
        this.outputStyle.set((Object)OutputStyle.valueOf((String)outputStyle.trim().toUpperCase()));
    }

    @Generated
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Generated
    public List<Object> getFunctionProviders() {
        return this.functionProviders;
    }

    @Generated
    public List<Importer> getHeaderImporters() {
        return this.headerImporters;
    }

    @Generated
    public Collection<Importer> getImporters() {
        return this.importers;
    }

    @Generated
    public ConfigurableFileCollection getIncludePaths() {
        return this.includePaths;
    }

    @Generated
    public Property<String> getIndent() {
        return this.indent;
    }

    @Generated
    public Property<String> getLinefeed() {
        return this.linefeed;
    }

    @Generated
    public Property<Boolean> getOmitSourceMapUrl() {
        return this.omitSourceMapUrl;
    }

    @Generated
    public Property<OutputStyle> getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public Property<String> getPluginPath() {
        return this.pluginPath;
    }

    @Generated
    public Property<Integer> getPrecision() {
        return this.precision;
    }

    @Generated
    public Property<Boolean> getSourceComments() {
        return this.sourceComments;
    }

    @Generated
    public Property<Boolean> getSourceMapContents() {
        return this.sourceMapContents;
    }

    @Generated
    public Property<Boolean> getSourceMapEmbed() {
        return this.sourceMapEmbed;
    }

    @Generated
    public Property<Boolean> getSourceMapEnabled() {
        return this.sourceMapEnabled;
    }

    @Generated
    public Property<URI> getSourceMapRoot() {
        return this.sourceMapRoot;
    }

    @Generated
    public void setFunctionProviders(List<Object> functionProviders) {
        this.functionProviders = functionProviders;
    }

    @Generated
    public void setHeaderImporters(List<Importer> headerImporters) {
        this.headerImporters = headerImporters;
    }

    @Generated
    public void setImporters(Collection<Importer> importers) {
        this.importers = importers;
    }

    public class LoggingFunctionProvider {
        @WarnFunction
        public void warn(String message) {
            SassCompile.this.getLogger().warn(message);
        }

        @ErrorFunction
        public void error(String message) {
            SassCompile.this.getLogger().error(message);
        }

        @DebugFunction
        public void debug(String message) {
            SassCompile.this.getLogger().info(message);
        }
    }
}

