/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jsass;

import io.freefair.gradle.plugins.jsass.JSassBasePlugin;
import io.freefair.gradle.plugins.jsass.PrepareWebjars;
import io.freefair.gradle.plugins.jsass.SassCompile;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskProvider;

public class JSassWebjarsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JSassBasePlugin.class);
        Configuration webjars = (Configuration)project.getConfigurations().create("webjars");
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> webjars.extendsFrom(new Configuration[]{project.getConfigurations().getByName("compileClasspath")}));
        TaskProvider prepareWebjarsTaskProvider = project.getTasks().register("prepareWebjars", PrepareWebjars.class, prepareWebjars -> {
            prepareWebjars.getWebjars().from(new Object[]{webjars});
            prepareWebjars.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("jsass/webjars"));
        });
        project.getTasks().withType(SassCompile.class).configureEach(sassCompile -> sassCompile.getIncludePaths().from(new Object[]{prepareWebjarsTaskProvider}));
    }
}

