/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jsass;

import io.freefair.gradle.plugins.jsass.JSassWebjarsPlugin;
import io.freefair.gradle.plugins.jsass.SassCompile;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JSassJavaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JSassWebjarsPlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        File baseDestinationDir = new File(project.getBuildDir(), "jsass");
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            String taskName = sourceSet.getCompileTaskName("Sass");
            TaskProvider sassCompileTaskProvider = project.getTasks().register(taskName, SassCompile.class, sassCompile -> {
                sassCompile.setSource((FileTree)sourceSet.getResources());
                sassCompile.getDestinationDir().set(new File(baseDestinationDir, sourceSet.getName()));
                sassCompile.setGroup("build");
                sassCompile.setDescription("Compile sass and scss files for the " + sourceSet.getName() + " source set");
            });
            project.getTasks().named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class).configure(processResources -> processResources.from(new Object[]{sassCompileTaskProvider}));
        });
    }
}

