/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jsass;

import java.io.File;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class PrepareWebjars
extends DefaultTask {
    @OutputDirectory
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    private final ConfigurableFileCollection webjars = this.getProject().files(new Object[0]);

    @TaskAction
    public void extractWebjars() {
        this.getProject().sync(sync -> {
            sync.into((Object)this.outputDirectory);
            sync.setDuplicatesStrategy(DuplicatesStrategy.WARN);
            this.webjars.filter(File::isFile).getFiles().forEach(file -> sync.from((Object)this.getProject().zipTree(file), jarSpec -> {
                jarSpec.include(new String[]{"META-INF/resources/webjars/**"});
                jarSpec.setIncludeEmptyDirs(false);
                jarSpec.eachFile(fcd -> fcd.setPath(fcd.getPath().replaceFirst("META-INF/resources/webjars/(.*?)/(.*?)/", "$1/")));
            }));
        });
    }

    @Generated
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public ConfigurableFileCollection getWebjars() {
        return this.webjars;
    }
}

