/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.sass;

import io.freefair.gradle.plugins.sass.SassCompile;
import io.freefair.gradle.plugins.sass.SassWebjarsPlugin;
import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.jvm.tasks.ProcessResources;

@Incubating
public class SassJavaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(SassWebjarsPlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        File baseDestinationDir = new File(project.getBuildDir(), "sass");
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(sourceSet -> {
            String taskName = sourceSet.getCompileTaskName("Sass");
            TaskProvider sassCompileTaskProvider = project.getTasks().register(taskName, SassCompile.class, sassCompile -> {
                sassCompile.setSource((FileTree)sourceSet.getResources());
                sassCompile.getDestinationDir().set(new File(baseDestinationDir, sourceSet.getName()));
                sassCompile.setGroup("build");
                sassCompile.setDescription("Compile sass and scss files for the " + sourceSet.getName() + " source set");
            });
            project.getTasks().named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class).configure(processResources -> processResources.from(new Object[]{sassCompileTaskProvider}));
        });
    }
}

