/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Biquad {
    public double mA0;
    public double mA1;
    public double mA2;
    public double mB1;
    public double mB2;
    public double mB0;

    public void applyScale(double scale) {
        this.mB0 *= scale;
        this.mB1 *= scale;
        this.mB2 *= scale;
    }

    public double getA0() {
        return this.mA0;
    }

    public double getA1() {
        return this.mA1 * this.mA0;
    }

    public double getA2() {
        return this.mA2 * this.mA0;
    }

    public double getB0() {
        return this.mB0 * this.mA0;
    }

    public double getB1() {
        return this.mB1 * this.mA0;
    }

    public double getB2() {
        return this.mB2 * this.mA0;
    }

    public Complex response(double normalizedFrequency) {
        double a0 = this.getA0();
        double a1 = this.getA1();
        double a2 = this.getA2();
        double b0 = this.getB0();
        double b1 = this.getB1();
        double b2 = this.getB2();
        double w = Math.PI * 2 * normalizedFrequency;
        Complex czn1 = ComplexUtils.polar2Complex((double)1.0, (double)(-w));
        Complex czn2 = ComplexUtils.polar2Complex((double)1.0, (double)(-2.0 * w));
        Complex ch = new Complex(1.0);
        Complex cbot = new Complex(1.0);
        Complex ct = new Complex(b0 / a0);
        ct = ct.add(czn1.multiply(b1 / a0));
        ct = ct.add(czn2.multiply(b2 / a0));
        Complex cb = new Complex(1.0);
        cb = cb.add(czn1.multiply(a1 / a0));
        cb = cb.add(czn2.multiply(a2 / a0));
        ch = ch.multiply(ct);
        cbot = cbot.multiply(cb);
        return ch.divide(cbot);
    }

    public void setCoefficients(double a0, double a1, double a2, double b0, double b1, double b2) {
        this.mA0 = a0;
        this.mA1 = a1 / a0;
        this.mA2 = a2 / a0;
        this.mB0 = b0 / a0;
        this.mB1 = b1 / a0;
        this.mB2 = b2 / a0;
    }

    public void setIdentity() {
        this.setCoefficients(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void setOnePole(Complex pole, Complex zero) {
        double a0 = 1.0;
        double a1 = -pole.getReal();
        double a2 = 0.0;
        double b0 = -zero.getReal();
        double b1 = 1.0;
        double b2 = 0.0;
        this.setCoefficients(1.0, a1, 0.0, b0, 1.0, 0.0);
    }

    public void setPoleZeroPair(PoleZeroPair pair) {
        if (pair.isSinglePole()) {
            this.setOnePole(pair.poles.first, pair.zeros.first);
        } else {
            this.setTwoPole(pair.poles.first, pair.zeros.first, pair.poles.second, pair.zeros.second);
        }
    }

    public void setTwoPole(Complex pole1, Complex zero1, Complex pole2, Complex zero2) {
        double b2;
        double b1;
        double a2;
        double a1;
        double a0 = 1.0;
        if (pole1.getImaginary() == 0.0) {
            a1 = -(pole1.getReal() + pole2.getReal());
            a2 = pole1.getReal() * pole2.getReal();
        } else {
            a1 = -2.0 * pole1.getReal();
            a2 = pole1.abs() * pole1.abs();
        }
        double b0 = 1.0;
        if (zero1.getImaginary() == 0.0) {
            b1 = -(zero1.getReal() + zero2.getReal());
            b2 = zero1.getReal() * zero2.getReal();
        } else {
            b1 = -2.0 * zero1.getReal();
            b2 = zero1.abs() * zero1.abs();
        }
        this.setCoefficients(1.0, a1, a2, 1.0, b1, b2);
    }
}

