/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import javax.inject.Inject;
import org.apache.deltaspike.core.api.config.ConfigProperty;

public class CuratorConfig {
    private String zookeeperUrl;
    private String zooKeeperUser;
    private String zookeeperPassword;
    private int zookeeperRetryMax = 3;
    private int zookeeperRetryInterval = 500;
    private int zookeeperConnectionTimeOut = 15000;
    private int zookeeperSessionTimeout = 60000;

    @Inject
    public CuratorConfig(@ConfigProperty(name="ZOOKEEPER_URL") String zookeeperUrl, @ConfigProperty(name="ZOOKEEPER_USER") String zooKeeperUser, @ConfigProperty(name="ZOOKEEPER_PASSWORD") String zookeeperPassword, @ConfigProperty(name="ZOOKEEPER_RETRY_POLICY_MAX_RETRIES", defaultValue="3") int zookeeperRetryMax, @ConfigProperty(name="ZOOKEEPER_RETRY_POLICY_INTERVAL_MS", defaultValue="500") int zookeeperRetryInterval, @ConfigProperty(name="ZOOKEEPER_CONNECTION_TIMEOUT", defaultValue="15000") int zookeeperConnectionTimeOut, @ConfigProperty(name="ZOOKEEPER_SESSION_TIMEOUT", defaultValue="60000") int zookeeperSessionTimeout) {
        this.zookeeperUrl = zookeeperUrl;
        this.zooKeeperUser = zooKeeperUser;
        this.zookeeperPassword = zookeeperPassword;
        this.zookeeperRetryMax = zookeeperRetryMax;
        this.zookeeperRetryInterval = zookeeperRetryInterval;
        this.zookeeperConnectionTimeOut = zookeeperConnectionTimeOut;
        this.zookeeperSessionTimeout = zookeeperSessionTimeout;
    }

    public String toString() {
        return "CuratorConfig{zookeeperUrl='" + this.zookeeperUrl + '\'' + ", zooKeeperUser='" + this.zooKeeperUser + '\'' + ", zookeeperPassword='" + this.zookeeperPassword + '\'' + ", zookeeperRetryMax=" + this.zookeeperRetryMax + ", zookeeperRetryInterval=" + this.zookeeperRetryInterval + ", zookeeperConnectionTimeOut=" + this.zookeeperConnectionTimeOut + ", zookeeperSessionTimeout=" + this.zookeeperSessionTimeout + '}';
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public int getZookeeperRetryMax() {
        return this.zookeeperRetryMax;
    }

    public int getZookeeperRetryInterval() {
        return this.zookeeperRetryInterval;
    }

    public int getZookeeperConnectionTimeOut() {
        return this.zookeeperConnectionTimeOut;
    }

    public int getZookeeperSessionTimeout() {
        return this.zookeeperSessionTimeout;
    }

    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CuratorConfig that = (CuratorConfig)o;
        if (this.zookeeperConnectionTimeOut != that.zookeeperConnectionTimeOut) {
            return false;
        }
        if (this.zookeeperRetryInterval != that.zookeeperRetryInterval) {
            return false;
        }
        if (this.zookeeperRetryMax != that.zookeeperRetryMax) {
            return false;
        }
        if (this.zookeeperSessionTimeout != that.zookeeperSessionTimeout) {
            return false;
        }
        if (this.zookeeperPassword != null ? !this.zookeeperPassword.equals(that.zookeeperPassword) : that.zookeeperPassword != null) {
            return false;
        }
        return !(this.zookeeperUrl != null ? !this.zookeeperUrl.equals(that.zookeeperUrl) : that.zookeeperUrl != null);
    }

    public int hashCode() {
        int result = this.zookeeperPassword != null ? this.zookeeperPassword.hashCode() : 0;
        result = 31 * result + this.zookeeperRetryMax;
        result = 31 * result + this.zookeeperRetryInterval;
        result = 31 * result + this.zookeeperConnectionTimeOut;
        result = 31 * result + this.zookeeperSessionTimeout;
        result = 31 * result + (this.zookeeperUrl != null ? this.zookeeperUrl.hashCode() : 0);
        return result;
    }

    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }
}

