/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.bootstrap.ZooKeeperServerFactory;
import io.fabric8.zookeeper.curator.CuratorConfig;
import io.fabric8.zookeeper.curator.ManagedCuratorFramework;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFactoryProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CuratorFactoryProducer.class);
    private ZooKeeperServerFactory serverFactory;

    @Produces
    @Singleton
    public CuratorFramework createCuratorFramework(CuratorConfig curatorConfig, ACLProvider aclProvider, QuorumPeerConfig peerConfig, @ConfigProperty(name="ZOOKEEPER_SERVER_ID", defaultValue="singleRootZkNode") String serverId) throws IOException, InterruptedException {
        String zookeeperUrl = curatorConfig.getZookeeperUrl();
        if (Strings.isNullOrBlank((String)zookeeperUrl)) {
            LOG.info("No ZooKeeper URL has been configured so creating a local ensemble server");
            this.serverFactory = new ZooKeeperServerFactory(peerConfig, "rootEnsembleNode");
            zookeeperUrl = this.serverFactory.getZooKeeperUrl();
            Objects.notNull((Object)zookeeperUrl, (String)"zookeeperUrl");
            curatorConfig.setZookeeperUrl(zookeeperUrl);
        }
        LOG.info("Connecting to ZooKeeper URL: {}", (Object)zookeeperUrl);
        ArrayList<ConnectionStateListener> connectionListenerList = new ArrayList<ConnectionStateListener>();
        CuratorFramework curatorFramework = ManagedCuratorFramework.createCuratorFramework(curatorConfig, aclProvider, connectionListenerList);
        curatorFramework.start();
        return curatorFramework;
    }
}

