/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerFactory {
    static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperServerFactory.class);
    private final QuorumPeerConfig peerConfig;
    private final String serverId;
    private SimpleServer simplerServer;
    private ClusteredServer clusteredServer;
    private Destroyable destroyable;
    private String zooKeeperUrl;

    public ZooKeeperServerFactory(QuorumPeerConfig peerConfig, String serverId) throws IOException, InterruptedException {
        this.peerConfig = peerConfig;
        this.serverId = serverId;
        LOGGER.info("Creating zookeeper server with: {}", (Object)peerConfig);
        if (!peerConfig.getServers().isEmpty()) {
            NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
            cnxnFactory.configure(peerConfig.getClientPortAddress(), peerConfig.getMaxClientCnxns());
            QuorumPeer quorumPeer = new QuorumPeer();
            quorumPeer.setClientPortAddress(peerConfig.getClientPortAddress());
            quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(peerConfig.getDataLogDir()), new File(peerConfig.getDataDir())));
            quorumPeer.setQuorumPeers(peerConfig.getServers());
            quorumPeer.setElectionType(peerConfig.getElectionAlg());
            quorumPeer.setMyid(peerConfig.getServerId());
            quorumPeer.setTickTime(peerConfig.getTickTime());
            quorumPeer.setMinSessionTimeout(peerConfig.getMinSessionTimeout());
            quorumPeer.setMaxSessionTimeout(peerConfig.getMaxSessionTimeout());
            quorumPeer.setInitLimit(peerConfig.getInitLimit());
            quorumPeer.setSyncLimit(peerConfig.getSyncLimit());
            quorumPeer.setQuorumVerifier(peerConfig.getQuorumVerifier());
            quorumPeer.setCnxnFactory((ServerCnxnFactory)cnxnFactory);
            quorumPeer.setZKDatabase(new ZKDatabase(quorumPeer.getTxnFactory()));
            quorumPeer.setLearnerType(peerConfig.getPeerType());
            try {
                LOGGER.debug("Starting quorum peer \"%s\" on address %s", (Object)quorumPeer.getMyid(), (Object)peerConfig.getClientPortAddress());
                quorumPeer.start();
                LOGGER.debug("Started quorum peer \"%s\"", (Object)quorumPeer.getMyid());
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to start quorum peer \"%s\", reason : %s ", quorumPeer.getMyid(), e.getMessage()));
                quorumPeer.shutdown();
                throw e;
            }
            this.updateZooKeeperURL(cnxnFactory.getLocalAddress(), cnxnFactory.getLocalPort());
            this.clusteredServer = new ClusteredServer(quorumPeer);
        } else {
            ServerConfig serverConfig = this.getServerConfig(peerConfig);
            ZooKeeperServer zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(serverConfig.getDataLogDir()), new File(serverConfig.getDataDir()));
            zkServer.setTxnLogFactory(ftxn);
            zkServer.setTickTime(serverConfig.getTickTime());
            zkServer.setMinSessionTimeout(serverConfig.getMinSessionTimeout());
            zkServer.setMaxSessionTimeout(serverConfig.getMaxSessionTimeout());
            NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory(){

                protected void configureSaslLogin() throws IOException {
                }
            };
            InetSocketAddress clientPortAddress = serverConfig.getClientPortAddress();
            cnxnFactory.configure(clientPortAddress, serverConfig.getMaxClientCnxns());
            this.updateZooKeeperURL(cnxnFactory.getLocalAddress(), cnxnFactory.getLocalPort());
            try {
                LOGGER.debug("Starting ZooKeeper server on address %s", (Object)peerConfig.getClientPortAddress());
                cnxnFactory.startup(zkServer);
                LOGGER.debug("Started ZooKeeper server");
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to start ZooKeeper server, reason : %s", e));
                cnxnFactory.shutdown();
                throw e;
            }
            this.simplerServer = new SimpleServer(zkServer, cnxnFactory);
        }
    }

    private void updateZooKeeperURL(InetSocketAddress localAddress, int localPort) {
        System.out.println("localAddress: " + localAddress + " localPort " + localPort);
        if (localAddress == null) {
            throw new IllegalStateException("No zookeeper URL can be found for the ensemble server!");
        }
        InetAddress address = localAddress.getAddress();
        String hostName = address != null ? address.getHostName() : localAddress.getHostName();
        this.zooKeeperUrl = hostName + ":" + localPort;
        LOGGER.info("ZooKeeper URL to local ensemble is: " + this.zooKeeperUrl);
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void destroy() throws Exception {
        LOGGER.info("Destroying zookeeper server: {}", (Object)this.destroyable);
        if (this.destroyable != null) {
            this.destroyable.destroy();
            this.destroyable = null;
        }
    }

    private QuorumPeerConfig getPeerConfig(Properties props) throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig peerConfig = new QuorumPeerConfig();
        peerConfig.parseProperties(props);
        LOGGER.info("Created zookeeper peer configuration: {}", (Object)peerConfig);
        return peerConfig;
    }

    private ServerConfig getServerConfig(QuorumPeerConfig peerConfig) {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(peerConfig);
        LOGGER.info("Created zookeeper server configuration: {}", (Object)serverConfig);
        return serverConfig;
    }

    static class ClusteredServer
    implements Destroyable,
    QuorumStats.Provider {
        private final QuorumPeer peer;

        ClusteredServer(QuorumPeer peer) {
            this.peer = peer;
        }

        @Override
        public void destroy() throws Exception {
            this.peer.shutdown();
            this.peer.join();
        }

        public String[] getQuorumPeers() {
            return this.peer.getQuorumPeers();
        }

        public String getServerState() {
            return this.peer.getServerState();
        }
    }

    static class SimpleServer
    implements Destroyable,
    ServerStats.Provider {
        private final ZooKeeperServer server;
        private final NIOServerCnxnFactory cnxnFactory;

        SimpleServer(ZooKeeperServer server, NIOServerCnxnFactory cnxnFactory) {
            this.server = server;
            this.cnxnFactory = cnxnFactory;
        }

        @Override
        public void destroy() throws Exception {
            this.cnxnFactory.shutdown();
            this.cnxnFactory.join();
            if (this.server.getZKDatabase() != null) {
                this.server.getZKDatabase().close();
            }
        }

        public long getOutstandingRequests() {
            return this.server.getOutstandingRequests();
        }

        public long getLastProcessedZxid() {
            return this.server.getLastProcessedZxid();
        }

        public String getState() {
            return this.server.getState();
        }

        public int getNumAliveConnections() {
            return this.server.getNumAliveConnections();
        }
    }

    static interface Destroyable {
        public void destroy() throws Exception;
    }
}

