/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.spring.context;

import io.fabric8.watcher.PathHelper;
import io.fabric8.watcher.Paths;
import io.fabric8.watcher.Processor;
import io.fabric8.watcher.file.FileWatcher;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class WatcherSpringContext
extends FileWatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(WatcherSpringContext.class);
    public static final String SPRING_BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    private ConcurrentHashMap<String, FileSystemXmlApplicationContext> contextMap = new ConcurrentHashMap();
    private ApplicationContext parentApplicationContext;
    private AtomicBoolean closing = new AtomicBoolean(false);

    public WatcherSpringContext() {
        this.setFileMatchPattern("glob:**.xml");
        this.setProcessor(new Processor(){

            public void process(Path path) {
                if (!WatcherSpringContext.this.closing.get()) {
                    WatcherSpringContext.this.addPath(path);
                }
            }

            public void onRemove(Path path) {
                if (!WatcherSpringContext.this.closing.get()) {
                    WatcherSpringContext.this.removePath(path);
                }
            }
        });
    }

    public void init() throws IOException {
        super.init();
        LOG.info("Watching directory " + this.getRoot() + " for Spring XML files to load");
    }

    public void destroy() {
        if (this.closing.compareAndSet(false, true)) {
            Set<Map.Entry<String, FileSystemXmlApplicationContext>> entries = this.contextMap.entrySet();
            for (Map.Entry<String, FileSystemXmlApplicationContext> entry : entries) {
                String url = entry.getKey();
                FileSystemXmlApplicationContext context = entry.getValue();
                this.closeContext(url, context);
            }
        }
        super.destroy();
    }

    public SortedSet<String> getApplicationContextPaths() {
        return new TreeSet<String>(this.contextMap.keySet());
    }

    public FileSystemXmlApplicationContext getApplicationContext(String path) {
        return this.contextMap.get(path);
    }

    public ApplicationContext getParentApplicationContext() {
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(ApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    protected void addPath(Path path) {
        String url = null;
        try {
            url = PathHelper.toUrlString((Path)path);
        }
        catch (MalformedURLException e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
        if (url != null) {
            FileSystemXmlApplicationContext context = this.contextMap.get(url);
            if (context != null) {
                try {
                    LOG.info("Refreshing context at path " + path + " context " + context);
                    context.refresh();
                }
                catch (Exception e) {
                    LOG.warn("Failed to refresh context at " + path + " context " + context + ". " + e, (Throwable)e);
                }
            } else {
                context = this.createContext(path, url);
                if (context != null) {
                    this.contextMap.put(url, context);
                    try {
                        LOG.info("Starting context at path " + path + " context " + context);
                        context.start();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to start context at " + path + " context " + context + ". " + e, (Throwable)e);
                    }
                }
            }
        }
    }

    protected void removePath(Path path) {
        try {
            String url = PathHelper.toUrlString((Path)path);
            FileSystemXmlApplicationContext context = this.contextMap.remove(url);
            this.closeContext(url, context);
        }
        catch (MalformedURLException e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
    }

    protected void closeContext(String url, FileSystemXmlApplicationContext context) {
        if (context != null) {
            try {
                LOG.info("Closing context at path " + url + " context " + context);
                context.close();
            }
            catch (Exception e) {
                LOG.info("Failed to close at " + url + " context " + context + ". " + e, (Throwable)e);
            }
        }
    }

    protected FileSystemXmlApplicationContext createContext(Path path, String url) {
        if (!Paths.hasNamespace((Path)path, (String[])new String[]{SPRING_BEANS_NAMESPACE_URI})) {
            LOG.info("Ignoring XML file " + path + " which is not a spring XML");
            return null;
        }
        String[] locations = new String[]{url};
        if (this.parentApplicationContext != null) {
            return new FileSystemXmlApplicationContext(locations, true, this.parentApplicationContext);
        }
        return new FileSystemXmlApplicationContext(locations, true);
    }
}

