/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.CompositeFilter;
import io.fabric8.common.util.Filter;
import java.util.Arrays;
import java.util.List;

public class Filters {
    public static <T> Filter<T> trueFilter() {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return true;
            }

            public String toString() {
                return "TrueFilter";
            }
        };
    }

    public static <T> Filter<T> falseFilter() {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return false;
            }

            public String toString() {
                return "FalseFilter";
            }
        };
    }

    public static <T> boolean matches(T value, List<? extends Filter<T>> filters) {
        if (filters != null) {
            for (Filter<T> filter : filters) {
                if (!filter.matches(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean matches(T value, List<? extends Filter<T>> includeFilters, List<? extends Filter<T>> excludeFilters) {
        if (Filters.matches(value, excludeFilters)) {
            return false;
        }
        return includeFilters == null || includeFilters.isEmpty() || Filters.matches(value, includeFilters);
    }

    public static <T> Filter<T> compositeFilter(List<Filter<T>> filters) {
        if (filters.size() == 0) {
            return Filters.falseFilter();
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new CompositeFilter<T>(filters);
    }

    public static <T> Filter<T> or(final Filter<T> ... filters) {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                for (Filter filter : filters) {
                    if (filter == null || !filter.matches(t)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "OrFilter" + Arrays.asList(filters);
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> filter) {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return !filter.matches(t);
            }

            public String toString() {
                return "Not(" + filter + ")";
            }
        };
    }

    public static <T> boolean isEmpty(Filter<T> filter) {
        boolean empty = false;
        if (filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)filter;
            empty = compositeFilter.isEmpty();
        }
        return empty;
    }

    public static Filter<String> createStringFilter(final String text) {
        if (text.startsWith("!")) {
            String remaining = text.substring(1);
            return Filters.not(Filters.createStringFilter(remaining));
        }
        if (text == null || text.length() == 0 || text.startsWith("*")) {
            return Filters.trueFilter();
        }
        if (text.endsWith("*")) {
            final String prefix = text.substring(0, text.length() - 1);
            return new Filter<String>(){

                @Override
                public boolean matches(String s) {
                    return s.startsWith(prefix);
                }

                public String toString() {
                    return "StartsWith(" + prefix + ")";
                }
            };
        }
        return new Filter<String>(){

            @Override
            public boolean matches(String s) {
                return text.equals(s);
            }

            public String toString() {
                return "Equals(" + text + ")";
            }
        };
    }
}

