/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.support;

import io.fabric8.common.util.Objects;
import io.fabric8.watcher.Processor;
import io.fabric8.watcher.Watcher;
import io.fabric8.watcher.WatcherListener;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class WatcherSupport
implements Watcher {
    private List<WatcherListener> listeners = new CopyOnWriteArrayList<WatcherListener>();
    private Processor processor;

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public void addListener(WatcherListener listener) {
        Objects.notNull(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(WatcherListener listener) {
        this.listeners.remove(listener);
    }

    protected List<WatcherListener> getListeners() {
        return new ArrayList<WatcherListener>(this.listeners);
    }

    protected void fireListeners(Path child, WatchEvent.Kind kind) {
        List<WatcherListener> list = this.getListeners();
        for (WatcherListener listener : list) {
            listener.onWatchEvent(child, kind);
        }
    }
}

