/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.batch.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobCondition;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobConditionBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobConditionFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobState;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobStateBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobStateFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobStatus;
import io.fabric8.volcano.api.model.batch.v1alpha1.TaskState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JobStatusFluent<A extends JobStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<JobConditionBuilder> conditions = new ArrayList();
    private Map<String, String> controlledResources;
    private Integer failed;
    private Integer minAvailable;
    private Integer pending;
    private Integer retryCount;
    private Integer running;
    private Duration runningDuration;
    private JobStateBuilder state;
    private Integer succeeded;
    private Map<String, TaskState> taskStatusCount;
    private Integer terminating;
    private Integer unknown;
    private Integer version;
    private Map<String, Object> additionalProperties;

    public JobStatusFluent() {
    }

    public JobStatusFluent(JobStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JobStatus instance) {
        JobStatus jobStatus = instance = instance != null ? instance : new JobStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withControlledResources(instance.getControlledResources());
            this.withFailed(instance.getFailed());
            this.withMinAvailable(instance.getMinAvailable());
            this.withPending(instance.getPending());
            this.withRetryCount(instance.getRetryCount());
            this.withRunning(instance.getRunning());
            this.withRunningDuration(instance.getRunningDuration());
            this.withState(instance.getState());
            this.withSucceeded(instance.getSucceeded());
            this.withTaskStatusCount(instance.getTaskStatusCount());
            this.withTerminating(instance.getTerminating());
            this.withUnknown(instance.getUnknown());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(JobCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<JobCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<JobConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JobCondition> buildConditions() {
        return this.conditions != null ? JobStatusFluent.build(this.conditions) : null;
    }

    public JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String status) {
        return this.addToConditions(new JobCondition(lastTransitionTime, status));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, JobCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToControlledResources(String key, String value) {
        if (this.controlledResources == null && key != null && value != null) {
            this.controlledResources = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.controlledResources.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToControlledResources(Map<String, String> map) {
        if (this.controlledResources == null && map != null) {
            this.controlledResources = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.controlledResources.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromControlledResources(String key) {
        if (this.controlledResources == null) {
            return (A)((Object)this);
        }
        if (key != null && this.controlledResources != null) {
            this.controlledResources.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromControlledResources(Map<String, String> map) {
        if (this.controlledResources == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.controlledResources == null) continue;
                this.controlledResources.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getControlledResources() {
        return this.controlledResources;
    }

    public <K, V> A withControlledResources(Map<String, String> controlledResources) {
        this.controlledResources = controlledResources == null ? null : new LinkedHashMap<String, String>(controlledResources);
        return (A)((Object)this);
    }

    public boolean hasControlledResources() {
        return this.controlledResources != null;
    }

    public Integer getFailed() {
        return this.failed;
    }

    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)((Object)this);
    }

    public boolean hasFailed() {
        return this.failed != null;
    }

    public Integer getMinAvailable() {
        return this.minAvailable;
    }

    public A withMinAvailable(Integer minAvailable) {
        this.minAvailable = minAvailable;
        return (A)((Object)this);
    }

    public boolean hasMinAvailable() {
        return this.minAvailable != null;
    }

    public Integer getPending() {
        return this.pending;
    }

    public A withPending(Integer pending) {
        this.pending = pending;
        return (A)((Object)this);
    }

    public boolean hasPending() {
        return this.pending != null;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public A withRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
        return (A)((Object)this);
    }

    public boolean hasRetryCount() {
        return this.retryCount != null;
    }

    public Integer getRunning() {
        return this.running;
    }

    public A withRunning(Integer running) {
        this.running = running;
        return (A)((Object)this);
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public Duration getRunningDuration() {
        return this.runningDuration;
    }

    public A withRunningDuration(Duration runningDuration) {
        this.runningDuration = runningDuration;
        return (A)((Object)this);
    }

    public boolean hasRunningDuration() {
        return this.runningDuration != null;
    }

    public JobState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    public A withState(JobState state) {
        this._visitables.remove((Object)"state");
        if (state != null) {
            this.state = new JobStateBuilder(state);
            this._visitables.get((Object)"state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get((Object)"state").remove((Object)this.state);
        }
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public A withNewState(String lastTransitionTime, String message, String phase, String reason) {
        return this.withState(new JobState(lastTransitionTime, message, phase, reason));
    }

    public StateNested<A> withNewState() {
        return new StateNested(null);
    }

    public StateNested<A> withNewStateLike(JobState item) {
        return new StateNested(item);
    }

    public StateNested<A> editState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(null));
    }

    public StateNested<A> editOrNewState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(new JobStateBuilder().build()));
    }

    public StateNested<A> editOrNewStateLike(JobState item) {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(item));
    }

    public Integer getSucceeded() {
        return this.succeeded;
    }

    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)((Object)this);
    }

    public boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public A addToTaskStatusCount(String key, TaskState value) {
        if (this.taskStatusCount == null && key != null && value != null) {
            this.taskStatusCount = new LinkedHashMap<String, TaskState>();
        }
        if (key != null && value != null) {
            this.taskStatusCount.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTaskStatusCount(Map<String, TaskState> map) {
        if (this.taskStatusCount == null && map != null) {
            this.taskStatusCount = new LinkedHashMap<String, TaskState>();
        }
        if (map != null) {
            this.taskStatusCount.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromTaskStatusCount(String key) {
        if (this.taskStatusCount == null) {
            return (A)((Object)this);
        }
        if (key != null && this.taskStatusCount != null) {
            this.taskStatusCount.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromTaskStatusCount(Map<String, TaskState> map) {
        if (this.taskStatusCount == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.taskStatusCount == null) continue;
                this.taskStatusCount.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, TaskState> getTaskStatusCount() {
        return this.taskStatusCount;
    }

    public <K, V> A withTaskStatusCount(Map<String, TaskState> taskStatusCount) {
        this.taskStatusCount = taskStatusCount == null ? null : new LinkedHashMap<String, TaskState>(taskStatusCount);
        return (A)((Object)this);
    }

    public boolean hasTaskStatusCount() {
        return this.taskStatusCount != null;
    }

    public Integer getTerminating() {
        return this.terminating;
    }

    public A withTerminating(Integer terminating) {
        this.terminating = terminating;
        return (A)((Object)this);
    }

    public boolean hasTerminating() {
        return this.terminating != null;
    }

    public Integer getUnknown() {
        return this.unknown;
    }

    public A withUnknown(Integer unknown) {
        this.unknown = unknown;
        return (A)((Object)this);
    }

    public boolean hasUnknown() {
        return this.unknown != null;
    }

    public Integer getVersion() {
        return this.version;
    }

    public A withVersion(Integer version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusFluent that = (JobStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.controlledResources, that.controlledResources)) {
            return false;
        }
        if (!Objects.equals(this.failed, that.failed)) {
            return false;
        }
        if (!Objects.equals(this.minAvailable, that.minAvailable)) {
            return false;
        }
        if (!Objects.equals(this.pending, that.pending)) {
            return false;
        }
        if (!Objects.equals(this.retryCount, that.retryCount)) {
            return false;
        }
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        if (!Objects.equals(this.runningDuration, that.runningDuration)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals(this.succeeded, that.succeeded)) {
            return false;
        }
        if (!Objects.equals(this.taskStatusCount, that.taskStatusCount)) {
            return false;
        }
        if (!Objects.equals(this.terminating, that.terminating)) {
            return false;
        }
        if (!Objects.equals(this.unknown, that.unknown)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.controlledResources, this.failed, this.minAvailable, this.pending, this.retryCount, this.running, this.runningDuration, this.state, this.succeeded, this.taskStatusCount, this.terminating, this.unknown, this.version, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.controlledResources != null && !this.controlledResources.isEmpty()) {
            sb.append("controlledResources:");
            sb.append(String.valueOf(this.controlledResources) + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.minAvailable != null) {
            sb.append("minAvailable:");
            sb.append(this.minAvailable + ",");
        }
        if (this.pending != null) {
            sb.append("pending:");
            sb.append(this.pending + ",");
        }
        if (this.retryCount != null) {
            sb.append("retryCount:");
            sb.append(this.retryCount + ",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running + ",");
        }
        if (this.runningDuration != null) {
            sb.append("runningDuration:");
            sb.append(String.valueOf(this.runningDuration) + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(String.valueOf((Object)this.state) + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded + ",");
        }
        if (this.taskStatusCount != null && !this.taskStatusCount.isEmpty()) {
            sb.append("taskStatusCount:");
            sb.append(String.valueOf(this.taskStatusCount) + ",");
        }
        if (this.terminating != null) {
            sb.append("terminating:");
            sb.append(this.terminating + ",");
        }
        if (this.unknown != null) {
            sb.append("unknown:");
            sb.append(this.unknown + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StateNested<N>
    extends JobStateFluent<StateNested<N>>
    implements Nested<N> {
        JobStateBuilder builder;

        StateNested(JobState item) {
            this.builder = new JobStateBuilder(this, item);
        }

        public N and() {
            return (N)JobStatusFluent.this.withState(this.builder.build());
        }

        public N endState() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends JobConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        JobConditionBuilder builder;
        int index;

        ConditionsNested(int index, JobCondition item) {
            this.index = index;
            this.builder = new JobConditionBuilder(this, item);
        }

        public N and() {
            return (N)JobStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

