package io.fabric8.volcano.api.model.scheduling.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QueueStatusFluent<A extends QueueStatusFluent<A>> extends BaseFluent<A>{
  public QueueStatusFluent() {
  }
  
  public QueueStatusFluent(QueueStatus instance) {
    this.copyInstance(instance);
  }
  private Map<String,Quantity> allocated;
  private Integer completed;
  private Integer inqueue;
  private Integer pending;
  private ReservationBuilder reservation;
  private Integer running;
  private String state;
  private Integer unknown;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QueueStatus instance) {
    instance = (instance != null ? instance : new QueueStatus());
    if (instance != null) {
          this.withAllocated(instance.getAllocated());
          this.withCompleted(instance.getCompleted());
          this.withInqueue(instance.getInqueue());
          this.withPending(instance.getPending());
          this.withReservation(instance.getReservation());
          this.withRunning(instance.getRunning());
          this.withState(instance.getState());
          this.withUnknown(instance.getUnknown());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAllocated(String key,Quantity value) {
    if(this.allocated == null && key != null && value != null) { this.allocated = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocated.put(key, value);} return (A)this;
  }
  
  public A addToAllocated(Map<String,Quantity> map) {
    if(this.allocated == null && map != null) { this.allocated = new LinkedHashMap(); }
    if(map != null) { this.allocated.putAll(map);} return (A)this;
  }
  
  public A removeFromAllocated(String key) {
    if(this.allocated == null) { return (A) this; }
    if(key != null && this.allocated != null) {this.allocated.remove(key);} return (A)this;
  }
  
  public A removeFromAllocated(Map<String,Quantity> map) {
    if(this.allocated == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocated != null){this.allocated.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getAllocated() {
    return this.allocated;
  }
  
  public <K,V>A withAllocated(Map<String,Quantity> allocated) {
    if (allocated == null) {
      this.allocated = null;
    } else {
      this.allocated = new LinkedHashMap(allocated);
    }
    return (A) this;
  }
  
  public boolean hasAllocated() {
    return this.allocated != null;
  }
  
  public Integer getCompleted() {
    return this.completed;
  }
  
  public A withCompleted(Integer completed) {
    this.completed = completed;
    return (A) this;
  }
  
  public boolean hasCompleted() {
    return this.completed != null;
  }
  
  public Integer getInqueue() {
    return this.inqueue;
  }
  
  public A withInqueue(Integer inqueue) {
    this.inqueue = inqueue;
    return (A) this;
  }
  
  public boolean hasInqueue() {
    return this.inqueue != null;
  }
  
  public Integer getPending() {
    return this.pending;
  }
  
  public A withPending(Integer pending) {
    this.pending = pending;
    return (A) this;
  }
  
  public boolean hasPending() {
    return this.pending != null;
  }
  
  public Reservation buildReservation() {
    return this.reservation != null ? this.reservation.build() : null;
  }
  
  public A withReservation(Reservation reservation) {
    this._visitables.remove("reservation");
    if (reservation != null) {
        this.reservation = new ReservationBuilder(reservation);
        this._visitables.get("reservation").add(this.reservation);
    } else {
        this.reservation = null;
        this._visitables.get("reservation").remove(this.reservation);
    }
    return (A) this;
  }
  
  public boolean hasReservation() {
    return this.reservation != null;
  }
  
  public ReservationNested<A> withNewReservation() {
    return new ReservationNested(null);
  }
  
  public ReservationNested<A> withNewReservationLike(Reservation item) {
    return new ReservationNested(item);
  }
  
  public ReservationNested<A> editReservation() {
    return withNewReservationLike(java.util.Optional.ofNullable(buildReservation()).orElse(null));
  }
  
  public ReservationNested<A> editOrNewReservation() {
    return withNewReservationLike(java.util.Optional.ofNullable(buildReservation()).orElse(new ReservationBuilder().build()));
  }
  
  public ReservationNested<A> editOrNewReservationLike(Reservation item) {
    return withNewReservationLike(java.util.Optional.ofNullable(buildReservation()).orElse(item));
  }
  
  public Integer getRunning() {
    return this.running;
  }
  
  public A withRunning(Integer running) {
    this.running = running;
    return (A) this;
  }
  
  public boolean hasRunning() {
    return this.running != null;
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public Integer getUnknown() {
    return this.unknown;
  }
  
  public A withUnknown(Integer unknown) {
    this.unknown = unknown;
    return (A) this;
  }
  
  public boolean hasUnknown() {
    return this.unknown != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QueueStatusFluent that = (QueueStatusFluent) o;
    if (!java.util.Objects.equals(allocated, that.allocated)) return false;
    if (!java.util.Objects.equals(completed, that.completed)) return false;
    if (!java.util.Objects.equals(inqueue, that.inqueue)) return false;
    if (!java.util.Objects.equals(pending, that.pending)) return false;
    if (!java.util.Objects.equals(reservation, that.reservation)) return false;
    if (!java.util.Objects.equals(running, that.running)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(unknown, that.unknown)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allocated,  completed,  inqueue,  pending,  reservation,  running,  state,  unknown,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocated != null && !allocated.isEmpty()) { sb.append("allocated:"); sb.append(allocated + ","); }
    if (completed != null) { sb.append("completed:"); sb.append(completed + ","); }
    if (inqueue != null) { sb.append("inqueue:"); sb.append(inqueue + ","); }
    if (pending != null) { sb.append("pending:"); sb.append(pending + ","); }
    if (reservation != null) { sb.append("reservation:"); sb.append(reservation + ","); }
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (unknown != null) { sb.append("unknown:"); sb.append(unknown + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ReservationNested<N> extends ReservationFluent<ReservationNested<N>> implements Nested<N>{
    ReservationNested(Reservation item) {
      this.builder = new ReservationBuilder(this, item);
    }
    ReservationBuilder builder;
    
    public N and() {
      return (N) QueueStatusFluent.this.withReservation(builder.build());
    }
    
    public N endReservation() {
      return and();
    }
    
  
  }

}