package io.fabric8.volcano.api.model.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QueueSpecFluent<A extends QueueSpecFluent<A>> extends BaseFluent<A>{
  public QueueSpecFluent() {
  }
  
  public QueueSpecFluent(QueueSpec instance) {
    this.copyInstance(instance);
  }
  private AffinityBuilder affinity;
  private Map<String,Quantity> capability;
  private Map<String,Quantity> deserved;
  private ArrayList<ClusterBuilder> extendClusters = new ArrayList<ClusterBuilder>();
  private GuaranteeBuilder guarantee;
  private String parent;
  private Integer priority;
  private Boolean reclaimable;
  private String type;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QueueSpec instance) {
    instance = (instance != null ? instance : new QueueSpec());
    if (instance != null) {
          this.withAffinity(instance.getAffinity());
          this.withCapability(instance.getCapability());
          this.withDeserved(instance.getDeserved());
          this.withExtendClusters(instance.getExtendClusters());
          this.withGuarantee(instance.getGuarantee());
          this.withParent(instance.getParent());
          this.withPriority(instance.getPriority());
          this.withReclaimable(instance.getReclaimable());
          this.withType(instance.getType());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Affinity buildAffinity() {
    return this.affinity != null ? this.affinity.build() : null;
  }
  
  public A withAffinity(Affinity affinity) {
    this._visitables.remove("affinity");
    if (affinity != null) {
        this.affinity = new AffinityBuilder(affinity);
        this._visitables.get("affinity").add(this.affinity);
    } else {
        this.affinity = null;
        this._visitables.get("affinity").remove(this.affinity);
    }
    return (A) this;
  }
  
  public boolean hasAffinity() {
    return this.affinity != null;
  }
  
  public AffinityNested<A> withNewAffinity() {
    return new AffinityNested(null);
  }
  
  public AffinityNested<A> withNewAffinityLike(Affinity item) {
    return new AffinityNested(item);
  }
  
  public AffinityNested<A> editAffinity() {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(null));
  }
  
  public AffinityNested<A> editOrNewAffinity() {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(new AffinityBuilder().build()));
  }
  
  public AffinityNested<A> editOrNewAffinityLike(Affinity item) {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(item));
  }
  
  public A addToCapability(String key,Quantity value) {
    if(this.capability == null && key != null && value != null) { this.capability = new LinkedHashMap(); }
    if(key != null && value != null) {this.capability.put(key, value);} return (A)this;
  }
  
  public A addToCapability(Map<String,Quantity> map) {
    if(this.capability == null && map != null) { this.capability = new LinkedHashMap(); }
    if(map != null) { this.capability.putAll(map);} return (A)this;
  }
  
  public A removeFromCapability(String key) {
    if(this.capability == null) { return (A) this; }
    if(key != null && this.capability != null) {this.capability.remove(key);} return (A)this;
  }
  
  public A removeFromCapability(Map<String,Quantity> map) {
    if(this.capability == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capability != null){this.capability.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getCapability() {
    return this.capability;
  }
  
  public <K,V>A withCapability(Map<String,Quantity> capability) {
    if (capability == null) {
      this.capability = null;
    } else {
      this.capability = new LinkedHashMap(capability);
    }
    return (A) this;
  }
  
  public boolean hasCapability() {
    return this.capability != null;
  }
  
  public A addToDeserved(String key,Quantity value) {
    if(this.deserved == null && key != null && value != null) { this.deserved = new LinkedHashMap(); }
    if(key != null && value != null) {this.deserved.put(key, value);} return (A)this;
  }
  
  public A addToDeserved(Map<String,Quantity> map) {
    if(this.deserved == null && map != null) { this.deserved = new LinkedHashMap(); }
    if(map != null) { this.deserved.putAll(map);} return (A)this;
  }
  
  public A removeFromDeserved(String key) {
    if(this.deserved == null) { return (A) this; }
    if(key != null && this.deserved != null) {this.deserved.remove(key);} return (A)this;
  }
  
  public A removeFromDeserved(Map<String,Quantity> map) {
    if(this.deserved == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.deserved != null){this.deserved.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getDeserved() {
    return this.deserved;
  }
  
  public <K,V>A withDeserved(Map<String,Quantity> deserved) {
    if (deserved == null) {
      this.deserved = null;
    } else {
      this.deserved = new LinkedHashMap(deserved);
    }
    return (A) this;
  }
  
  public boolean hasDeserved() {
    return this.deserved != null;
  }
  
  public A addToExtendClusters(int index,Cluster item) {
    if (this.extendClusters == null) {this.extendClusters = new ArrayList<ClusterBuilder>();}
    ClusterBuilder builder = new ClusterBuilder(item);
    if (index < 0 || index >= extendClusters.size()) {
        _visitables.get("extendClusters").add(builder);
        extendClusters.add(builder);
    } else {
        _visitables.get("extendClusters").add(builder);
        extendClusters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToExtendClusters(int index,Cluster item) {
    if (this.extendClusters == null) {this.extendClusters = new ArrayList<ClusterBuilder>();}
    ClusterBuilder builder = new ClusterBuilder(item);
    if (index < 0 || index >= extendClusters.size()) {
        _visitables.get("extendClusters").add(builder);
        extendClusters.add(builder);
    } else {
        _visitables.get("extendClusters").add(builder);
        extendClusters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToExtendClusters(io.fabric8.volcano.api.model.scheduling.v1beta1.Cluster... items) {
    if (this.extendClusters == null) {this.extendClusters = new ArrayList<ClusterBuilder>();}
    for (Cluster item : items) {ClusterBuilder builder = new ClusterBuilder(item);_visitables.get("extendClusters").add(builder);this.extendClusters.add(builder);} return (A)this;
  }
  
  public A addAllToExtendClusters(Collection<Cluster> items) {
    if (this.extendClusters == null) {this.extendClusters = new ArrayList<ClusterBuilder>();}
    for (Cluster item : items) {ClusterBuilder builder = new ClusterBuilder(item);_visitables.get("extendClusters").add(builder);this.extendClusters.add(builder);} return (A)this;
  }
  
  public A removeFromExtendClusters(io.fabric8.volcano.api.model.scheduling.v1beta1.Cluster... items) {
    if (this.extendClusters == null) return (A)this;
    for (Cluster item : items) {ClusterBuilder builder = new ClusterBuilder(item);_visitables.get("extendClusters").remove(builder); this.extendClusters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtendClusters(Collection<Cluster> items) {
    if (this.extendClusters == null) return (A)this;
    for (Cluster item : items) {ClusterBuilder builder = new ClusterBuilder(item);_visitables.get("extendClusters").remove(builder); this.extendClusters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtendClusters(Predicate<ClusterBuilder> predicate) {
    if (extendClusters == null) return (A) this;
    final Iterator<ClusterBuilder> each = extendClusters.iterator();
    final List visitables = _visitables.get("extendClusters");
    while (each.hasNext()) {
      ClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Cluster> buildExtendClusters() {
    return this.extendClusters != null ? build(extendClusters) : null;
  }
  
  public Cluster buildExtendCluster(int index) {
    return this.extendClusters.get(index).build();
  }
  
  public Cluster buildFirstExtendCluster() {
    return this.extendClusters.get(0).build();
  }
  
  public Cluster buildLastExtendCluster() {
    return this.extendClusters.get(extendClusters.size() - 1).build();
  }
  
  public Cluster buildMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
      for (ClusterBuilder item : extendClusters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
      for (ClusterBuilder item : extendClusters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtendClusters(List<Cluster> extendClusters) {
    if (this.extendClusters != null) {
      this._visitables.get("extendClusters").clear();
    }
    if (extendClusters != null) {
        this.extendClusters = new ArrayList();
        for (Cluster item : extendClusters) {
          this.addToExtendClusters(item);
        }
    } else {
      this.extendClusters = null;
    }
    return (A) this;
  }
  
  public A withExtendClusters(io.fabric8.volcano.api.model.scheduling.v1beta1.Cluster... extendClusters) {
    if (this.extendClusters != null) {
        this.extendClusters.clear();
        _visitables.remove("extendClusters");
    }
    if (extendClusters != null) {
      for (Cluster item : extendClusters) {
        this.addToExtendClusters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtendClusters() {
    return this.extendClusters != null && !this.extendClusters.isEmpty();
  }
  
  public ExtendClustersNested<A> addNewExtendCluster() {
    return new ExtendClustersNested(-1, null);
  }
  
  public ExtendClustersNested<A> addNewExtendClusterLike(Cluster item) {
    return new ExtendClustersNested(-1, item);
  }
  
  public ExtendClustersNested<A> setNewExtendClusterLike(int index,Cluster item) {
    return new ExtendClustersNested(index, item);
  }
  
  public ExtendClustersNested<A> editExtendCluster(int index) {
    if (extendClusters.size() <= index) throw new RuntimeException("Can't edit extendClusters. Index exceeds size.");
    return setNewExtendClusterLike(index, buildExtendCluster(index));
  }
  
  public ExtendClustersNested<A> editFirstExtendCluster() {
    if (extendClusters.size() == 0) throw new RuntimeException("Can't edit first extendClusters. The list is empty.");
    return setNewExtendClusterLike(0, buildExtendCluster(0));
  }
  
  public ExtendClustersNested<A> editLastExtendCluster() {
    int index = extendClusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extendClusters. The list is empty.");
    return setNewExtendClusterLike(index, buildExtendCluster(index));
  }
  
  public ExtendClustersNested<A> editMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extendClusters.size();i++) { 
    if (predicate.test(extendClusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extendClusters. No match found.");
    return setNewExtendClusterLike(index, buildExtendCluster(index));
  }
  
  public Guarantee buildGuarantee() {
    return this.guarantee != null ? this.guarantee.build() : null;
  }
  
  public A withGuarantee(Guarantee guarantee) {
    this._visitables.remove("guarantee");
    if (guarantee != null) {
        this.guarantee = new GuaranteeBuilder(guarantee);
        this._visitables.get("guarantee").add(this.guarantee);
    } else {
        this.guarantee = null;
        this._visitables.get("guarantee").remove(this.guarantee);
    }
    return (A) this;
  }
  
  public boolean hasGuarantee() {
    return this.guarantee != null;
  }
  
  public GuaranteeNested<A> withNewGuarantee() {
    return new GuaranteeNested(null);
  }
  
  public GuaranteeNested<A> withNewGuaranteeLike(Guarantee item) {
    return new GuaranteeNested(item);
  }
  
  public GuaranteeNested<A> editGuarantee() {
    return withNewGuaranteeLike(java.util.Optional.ofNullable(buildGuarantee()).orElse(null));
  }
  
  public GuaranteeNested<A> editOrNewGuarantee() {
    return withNewGuaranteeLike(java.util.Optional.ofNullable(buildGuarantee()).orElse(new GuaranteeBuilder().build()));
  }
  
  public GuaranteeNested<A> editOrNewGuaranteeLike(Guarantee item) {
    return withNewGuaranteeLike(java.util.Optional.ofNullable(buildGuarantee()).orElse(item));
  }
  
  public String getParent() {
    return this.parent;
  }
  
  public A withParent(String parent) {
    this.parent = parent;
    return (A) this;
  }
  
  public boolean hasParent() {
    return this.parent != null;
  }
  
  public Integer getPriority() {
    return this.priority;
  }
  
  public A withPriority(Integer priority) {
    this.priority = priority;
    return (A) this;
  }
  
  public boolean hasPriority() {
    return this.priority != null;
  }
  
  public Boolean getReclaimable() {
    return this.reclaimable;
  }
  
  public A withReclaimable(Boolean reclaimable) {
    this.reclaimable = reclaimable;
    return (A) this;
  }
  
  public boolean hasReclaimable() {
    return this.reclaimable != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QueueSpecFluent that = (QueueSpecFluent) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;
    if (!java.util.Objects.equals(capability, that.capability)) return false;
    if (!java.util.Objects.equals(deserved, that.deserved)) return false;
    if (!java.util.Objects.equals(extendClusters, that.extendClusters)) return false;
    if (!java.util.Objects.equals(guarantee, that.guarantee)) return false;
    if (!java.util.Objects.equals(parent, that.parent)) return false;
    if (!java.util.Objects.equals(priority, that.priority)) return false;
    if (!java.util.Objects.equals(reclaimable, that.reclaimable)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(affinity,  capability,  deserved,  extendClusters,  guarantee,  parent,  priority,  reclaimable,  type,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (capability != null && !capability.isEmpty()) { sb.append("capability:"); sb.append(capability + ","); }
    if (deserved != null && !deserved.isEmpty()) { sb.append("deserved:"); sb.append(deserved + ","); }
    if (extendClusters != null && !extendClusters.isEmpty()) { sb.append("extendClusters:"); sb.append(extendClusters + ","); }
    if (guarantee != null) { sb.append("guarantee:"); sb.append(guarantee + ","); }
    if (parent != null) { sb.append("parent:"); sb.append(parent + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (reclaimable != null) { sb.append("reclaimable:"); sb.append(reclaimable + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReclaimable() {
    return withReclaimable(true);
  }
  public class AffinityNested<N> extends AffinityFluent<AffinityNested<N>> implements Nested<N>{
    AffinityNested(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityBuilder builder;
    
    public N and() {
      return (N) QueueSpecFluent.this.withAffinity(builder.build());
    }
    
    public N endAffinity() {
      return and();
    }
    
  
  }
  public class ExtendClustersNested<N> extends ClusterFluent<ExtendClustersNested<N>> implements Nested<N>{
    ExtendClustersNested(int index,Cluster item) {
      this.index = index;
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterBuilder builder;
    int index;
    
    public N and() {
      return (N) QueueSpecFluent.this.setToExtendClusters(index,builder.build());
    }
    
    public N endExtendCluster() {
      return and();
    }
    
  
  }
  public class GuaranteeNested<N> extends GuaranteeFluent<GuaranteeNested<N>> implements Nested<N>{
    GuaranteeNested(Guarantee item) {
      this.builder = new GuaranteeBuilder(this, item);
    }
    GuaranteeBuilder builder;
    
    public N and() {
      return (N) QueueSpecFluent.this.withGuarantee(builder.build());
    }
    
    public N endGuarantee() {
      return and();
    }
    
  
  }

}