package io.fabric8.volcano.api.model.nodeinfo.v1alpha1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceInfoFluent<A extends ResourceInfoFluent<A>> extends BaseFluent<A>{
  public ResourceInfoFluent() {
  }
  
  public ResourceInfoFluent(ResourceInfo instance) {
    this.copyInstance(instance);
  }
  private String allocatable;
  private Integer capacity;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceInfo instance) {
    instance = (instance != null ? instance : new ResourceInfo());
    if (instance != null) {
          this.withAllocatable(instance.getAllocatable());
          this.withCapacity(instance.getCapacity());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAllocatable() {
    return this.allocatable;
  }
  
  public A withAllocatable(String allocatable) {
    this.allocatable = allocatable;
    return (A) this;
  }
  
  public boolean hasAllocatable() {
    return this.allocatable != null;
  }
  
  public Integer getCapacity() {
    return this.capacity;
  }
  
  public A withCapacity(Integer capacity) {
    this.capacity = capacity;
    return (A) this;
  }
  
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceInfoFluent that = (ResourceInfoFluent) o;
    if (!java.util.Objects.equals(allocatable, that.allocatable)) return false;
    if (!java.util.Objects.equals(capacity, that.capacity)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allocatable,  capacity,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocatable != null) { sb.append("allocatable:"); sb.append(allocatable + ","); }
    if (capacity != null) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}