package io.fabric8.volcano.api.model.flow.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobTemplateStatusFluent<A extends JobTemplateStatusFluent<A>> extends BaseFluent<A>{
  public JobTemplateStatusFluent() {
  }
  
  public JobTemplateStatusFluent(JobTemplateStatus instance) {
    this.copyInstance(instance);
  }
  private List<String> jobDependsOnList = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JobTemplateStatus instance) {
    instance = (instance != null ? instance : new JobTemplateStatus());
    if (instance != null) {
          this.withJobDependsOnList(instance.getJobDependsOnList());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToJobDependsOnList(int index,String item) {
    if (this.jobDependsOnList == null) {this.jobDependsOnList = new ArrayList<String>();}
    this.jobDependsOnList.add(index, item);
    return (A)this;
  }
  
  public A setToJobDependsOnList(int index,String item) {
    if (this.jobDependsOnList == null) {this.jobDependsOnList = new ArrayList<String>();}
    this.jobDependsOnList.set(index, item); return (A)this;
  }
  
  public A addToJobDependsOnList(java.lang.String... items) {
    if (this.jobDependsOnList == null) {this.jobDependsOnList = new ArrayList<String>();}
    for (String item : items) {this.jobDependsOnList.add(item);} return (A)this;
  }
  
  public A addAllToJobDependsOnList(Collection<String> items) {
    if (this.jobDependsOnList == null) {this.jobDependsOnList = new ArrayList<String>();}
    for (String item : items) {this.jobDependsOnList.add(item);} return (A)this;
  }
  
  public A removeFromJobDependsOnList(java.lang.String... items) {
    if (this.jobDependsOnList == null) return (A)this;
    for (String item : items) { this.jobDependsOnList.remove(item);} return (A)this;
  }
  
  public A removeAllFromJobDependsOnList(Collection<String> items) {
    if (this.jobDependsOnList == null) return (A)this;
    for (String item : items) { this.jobDependsOnList.remove(item);} return (A)this;
  }
  
  public List<String> getJobDependsOnList() {
    return this.jobDependsOnList;
  }
  
  public String getJobDependsOnList(int index) {
    return this.jobDependsOnList.get(index);
  }
  
  public String getFirstJobDependsOnList() {
    return this.jobDependsOnList.get(0);
  }
  
  public String getLastJobDependsOnList() {
    return this.jobDependsOnList.get(jobDependsOnList.size() - 1);
  }
  
  public String getMatchingJobDependsOnList(Predicate<String> predicate) {
      for (String item : jobDependsOnList) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingJobDependsOnList(Predicate<String> predicate) {
      for (String item : jobDependsOnList) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withJobDependsOnList(List<String> jobDependsOnList) {
    if (jobDependsOnList != null) {
        this.jobDependsOnList = new ArrayList();
        for (String item : jobDependsOnList) {
          this.addToJobDependsOnList(item);
        }
    } else {
      this.jobDependsOnList = null;
    }
    return (A) this;
  }
  
  public A withJobDependsOnList(java.lang.String... jobDependsOnList) {
    if (this.jobDependsOnList != null) {
        this.jobDependsOnList.clear();
        _visitables.remove("jobDependsOnList");
    }
    if (jobDependsOnList != null) {
      for (String item : jobDependsOnList) {
        this.addToJobDependsOnList(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasJobDependsOnList() {
    return this.jobDependsOnList != null && !this.jobDependsOnList.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobTemplateStatusFluent that = (JobTemplateStatusFluent) o;
    if (!java.util.Objects.equals(jobDependsOnList, that.jobDependsOnList)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(jobDependsOnList,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (jobDependsOnList != null && !jobDependsOnList.isEmpty()) { sb.append("jobDependsOnList:"); sb.append(jobDependsOnList + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}