package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobStatusFluent<A extends JobStatusFluent<A>> extends BaseFluent<A>{
  public JobStatusFluent() {
  }
  
  public JobStatusFluent(JobStatus instance) {
    this.copyInstance(instance);
  }
  private String endTimestamp;
  private String name;
  private Integer restartCount;
  private ArrayList<JobRunningHistoryBuilder> runningHistories = new ArrayList<JobRunningHistoryBuilder>();
  private String startTimestamp;
  private String state;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JobStatus instance) {
    instance = (instance != null ? instance : new JobStatus());
    if (instance != null) {
          this.withEndTimestamp(instance.getEndTimestamp());
          this.withName(instance.getName());
          this.withRestartCount(instance.getRestartCount());
          this.withRunningHistories(instance.getRunningHistories());
          this.withStartTimestamp(instance.getStartTimestamp());
          this.withState(instance.getState());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getEndTimestamp() {
    return this.endTimestamp;
  }
  
  public A withEndTimestamp(String endTimestamp) {
    this.endTimestamp = endTimestamp;
    return (A) this;
  }
  
  public boolean hasEndTimestamp() {
    return this.endTimestamp != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Integer getRestartCount() {
    return this.restartCount;
  }
  
  public A withRestartCount(Integer restartCount) {
    this.restartCount = restartCount;
    return (A) this;
  }
  
  public boolean hasRestartCount() {
    return this.restartCount != null;
  }
  
  public A addToRunningHistories(int index,JobRunningHistory item) {
    if (this.runningHistories == null) {this.runningHistories = new ArrayList<JobRunningHistoryBuilder>();}
    JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
    if (index < 0 || index >= runningHistories.size()) {
        _visitables.get("runningHistories").add(builder);
        runningHistories.add(builder);
    } else {
        _visitables.get("runningHistories").add(builder);
        runningHistories.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRunningHistories(int index,JobRunningHistory item) {
    if (this.runningHistories == null) {this.runningHistories = new ArrayList<JobRunningHistoryBuilder>();}
    JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
    if (index < 0 || index >= runningHistories.size()) {
        _visitables.get("runningHistories").add(builder);
        runningHistories.add(builder);
    } else {
        _visitables.get("runningHistories").add(builder);
        runningHistories.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRunningHistories(io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistory... items) {
    if (this.runningHistories == null) {this.runningHistories = new ArrayList<JobRunningHistoryBuilder>();}
    for (JobRunningHistory item : items) {JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);_visitables.get("runningHistories").add(builder);this.runningHistories.add(builder);} return (A)this;
  }
  
  public A addAllToRunningHistories(Collection<JobRunningHistory> items) {
    if (this.runningHistories == null) {this.runningHistories = new ArrayList<JobRunningHistoryBuilder>();}
    for (JobRunningHistory item : items) {JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);_visitables.get("runningHistories").add(builder);this.runningHistories.add(builder);} return (A)this;
  }
  
  public A removeFromRunningHistories(io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistory... items) {
    if (this.runningHistories == null) return (A)this;
    for (JobRunningHistory item : items) {JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);_visitables.get("runningHistories").remove(builder); this.runningHistories.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRunningHistories(Collection<JobRunningHistory> items) {
    if (this.runningHistories == null) return (A)this;
    for (JobRunningHistory item : items) {JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);_visitables.get("runningHistories").remove(builder); this.runningHistories.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRunningHistories(Predicate<JobRunningHistoryBuilder> predicate) {
    if (runningHistories == null) return (A) this;
    final Iterator<JobRunningHistoryBuilder> each = runningHistories.iterator();
    final List visitables = _visitables.get("runningHistories");
    while (each.hasNext()) {
      JobRunningHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JobRunningHistory> buildRunningHistories() {
    return this.runningHistories != null ? build(runningHistories) : null;
  }
  
  public JobRunningHistory buildRunningHistory(int index) {
    return this.runningHistories.get(index).build();
  }
  
  public JobRunningHistory buildFirstRunningHistory() {
    return this.runningHistories.get(0).build();
  }
  
  public JobRunningHistory buildLastRunningHistory() {
    return this.runningHistories.get(runningHistories.size() - 1).build();
  }
  
  public JobRunningHistory buildMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
      for (JobRunningHistoryBuilder item : runningHistories) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
      for (JobRunningHistoryBuilder item : runningHistories) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRunningHistories(List<JobRunningHistory> runningHistories) {
    if (this.runningHistories != null) {
      this._visitables.get("runningHistories").clear();
    }
    if (runningHistories != null) {
        this.runningHistories = new ArrayList();
        for (JobRunningHistory item : runningHistories) {
          this.addToRunningHistories(item);
        }
    } else {
      this.runningHistories = null;
    }
    return (A) this;
  }
  
  public A withRunningHistories(io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistory... runningHistories) {
    if (this.runningHistories != null) {
        this.runningHistories.clear();
        _visitables.remove("runningHistories");
    }
    if (runningHistories != null) {
      for (JobRunningHistory item : runningHistories) {
        this.addToRunningHistories(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRunningHistories() {
    return this.runningHistories != null && !this.runningHistories.isEmpty();
  }
  
  public A addNewRunningHistory(String endTimestamp,String startTimestamp,String state) {
    return (A)addToRunningHistories(new JobRunningHistory(endTimestamp, startTimestamp, state));
  }
  
  public RunningHistoriesNested<A> addNewRunningHistory() {
    return new RunningHistoriesNested(-1, null);
  }
  
  public RunningHistoriesNested<A> addNewRunningHistoryLike(JobRunningHistory item) {
    return new RunningHistoriesNested(-1, item);
  }
  
  public RunningHistoriesNested<A> setNewRunningHistoryLike(int index,JobRunningHistory item) {
    return new RunningHistoriesNested(index, item);
  }
  
  public RunningHistoriesNested<A> editRunningHistory(int index) {
    if (runningHistories.size() <= index) throw new RuntimeException("Can't edit runningHistories. Index exceeds size.");
    return setNewRunningHistoryLike(index, buildRunningHistory(index));
  }
  
  public RunningHistoriesNested<A> editFirstRunningHistory() {
    if (runningHistories.size() == 0) throw new RuntimeException("Can't edit first runningHistories. The list is empty.");
    return setNewRunningHistoryLike(0, buildRunningHistory(0));
  }
  
  public RunningHistoriesNested<A> editLastRunningHistory() {
    int index = runningHistories.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last runningHistories. The list is empty.");
    return setNewRunningHistoryLike(index, buildRunningHistory(index));
  }
  
  public RunningHistoriesNested<A> editMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<runningHistories.size();i++) { 
    if (predicate.test(runningHistories.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching runningHistories. No match found.");
    return setNewRunningHistoryLike(index, buildRunningHistory(index));
  }
  
  public String getStartTimestamp() {
    return this.startTimestamp;
  }
  
  public A withStartTimestamp(String startTimestamp) {
    this.startTimestamp = startTimestamp;
    return (A) this;
  }
  
  public boolean hasStartTimestamp() {
    return this.startTimestamp != null;
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobStatusFluent that = (JobStatusFluent) o;
    if (!java.util.Objects.equals(endTimestamp, that.endTimestamp)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(restartCount, that.restartCount)) return false;
    if (!java.util.Objects.equals(runningHistories, that.runningHistories)) return false;
    if (!java.util.Objects.equals(startTimestamp, that.startTimestamp)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(endTimestamp,  name,  restartCount,  runningHistories,  startTimestamp,  state,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endTimestamp != null) { sb.append("endTimestamp:"); sb.append(endTimestamp + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (restartCount != null) { sb.append("restartCount:"); sb.append(restartCount + ","); }
    if (runningHistories != null && !runningHistories.isEmpty()) { sb.append("runningHistories:"); sb.append(runningHistories + ","); }
    if (startTimestamp != null) { sb.append("startTimestamp:"); sb.append(startTimestamp + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RunningHistoriesNested<N> extends JobRunningHistoryFluent<RunningHistoriesNested<N>> implements Nested<N>{
    RunningHistoriesNested(int index,JobRunningHistory item) {
      this.index = index;
      this.builder = new JobRunningHistoryBuilder(this, item);
    }
    JobRunningHistoryBuilder builder;
    int index;
    
    public N and() {
      return (N) JobStatusFluent.this.setToRunningHistories(index,builder.build());
    }
    
    public N endRunningHistory() {
      return and();
    }
    
  
  }

}