/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistory;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistoryBuilder;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobRunningHistoryFluent;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JobStatusFluent<A extends JobStatusFluent<A>>
extends BaseFluent<A> {
    private String endTimestamp;
    private String name;
    private Integer restartCount;
    private ArrayList<JobRunningHistoryBuilder> runningHistories = new ArrayList();
    private String startTimestamp;
    private String state;
    private Map<String, Object> additionalProperties;

    public JobStatusFluent() {
    }

    public JobStatusFluent(JobStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JobStatus instance) {
        JobStatus jobStatus = instance = instance != null ? instance : new JobStatus();
        if (instance != null) {
            this.withEndTimestamp(instance.getEndTimestamp());
            this.withName(instance.getName());
            this.withRestartCount(instance.getRestartCount());
            this.withRunningHistories(instance.getRunningHistories());
            this.withStartTimestamp(instance.getStartTimestamp());
            this.withState(instance.getState());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getEndTimestamp() {
        return this.endTimestamp;
    }

    public A withEndTimestamp(String endTimestamp) {
        this.endTimestamp = endTimestamp;
        return (A)((Object)this);
    }

    public boolean hasEndTimestamp() {
        return this.endTimestamp != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)((Object)this);
    }

    public boolean hasRestartCount() {
        return this.restartCount != null;
    }

    public A addToRunningHistories(int index, JobRunningHistory item) {
        if (this.runningHistories == null) {
            this.runningHistories = new ArrayList();
        }
        JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
        if (index < 0 || index >= this.runningHistories.size()) {
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.add(builder);
        } else {
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRunningHistories(int index, JobRunningHistory item) {
        if (this.runningHistories == null) {
            this.runningHistories = new ArrayList();
        }
        JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
        if (index < 0 || index >= this.runningHistories.size()) {
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.add(builder);
        } else {
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRunningHistories(JobRunningHistory ... items) {
        if (this.runningHistories == null) {
            this.runningHistories = new ArrayList();
        }
        for (JobRunningHistory item : items) {
            JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRunningHistories(Collection<JobRunningHistory> items) {
        if (this.runningHistories == null) {
            this.runningHistories = new ArrayList();
        }
        for (JobRunningHistory item : items) {
            JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
            this._visitables.get((Object)"runningHistories").add(builder);
            this.runningHistories.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRunningHistories(JobRunningHistory ... items) {
        if (this.runningHistories == null) {
            return (A)((Object)this);
        }
        for (JobRunningHistory item : items) {
            JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
            this._visitables.get((Object)"runningHistories").remove((Object)builder);
            this.runningHistories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRunningHistories(Collection<JobRunningHistory> items) {
        if (this.runningHistories == null) {
            return (A)((Object)this);
        }
        for (JobRunningHistory item : items) {
            JobRunningHistoryBuilder builder = new JobRunningHistoryBuilder(item);
            this._visitables.get((Object)"runningHistories").remove((Object)builder);
            this.runningHistories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRunningHistories(Predicate<JobRunningHistoryBuilder> predicate) {
        if (this.runningHistories == null) {
            return (A)((Object)this);
        }
        Iterator<JobRunningHistoryBuilder> each = this.runningHistories.iterator();
        List visitables = this._visitables.get((Object)"runningHistories");
        while (each.hasNext()) {
            JobRunningHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JobRunningHistory> buildRunningHistories() {
        return this.runningHistories != null ? JobStatusFluent.build(this.runningHistories) : null;
    }

    public JobRunningHistory buildRunningHistory(int index) {
        return this.runningHistories.get(index).build();
    }

    public JobRunningHistory buildFirstRunningHistory() {
        return this.runningHistories.get(0).build();
    }

    public JobRunningHistory buildLastRunningHistory() {
        return this.runningHistories.get(this.runningHistories.size() - 1).build();
    }

    public JobRunningHistory buildMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
        for (JobRunningHistoryBuilder item : this.runningHistories) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
        for (JobRunningHistoryBuilder item : this.runningHistories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRunningHistories(List<JobRunningHistory> runningHistories) {
        if (this.runningHistories != null) {
            this._visitables.get((Object)"runningHistories").clear();
        }
        if (runningHistories != null) {
            this.runningHistories = new ArrayList();
            for (JobRunningHistory item : runningHistories) {
                this.addToRunningHistories(item);
            }
        } else {
            this.runningHistories = null;
        }
        return (A)((Object)this);
    }

    public A withRunningHistories(JobRunningHistory ... runningHistories) {
        if (this.runningHistories != null) {
            this.runningHistories.clear();
            this._visitables.remove((Object)"runningHistories");
        }
        if (runningHistories != null) {
            for (JobRunningHistory item : runningHistories) {
                this.addToRunningHistories(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRunningHistories() {
        return this.runningHistories != null && !this.runningHistories.isEmpty();
    }

    public A addNewRunningHistory(String endTimestamp, String startTimestamp, String state) {
        return this.addToRunningHistories(new JobRunningHistory(endTimestamp, startTimestamp, state));
    }

    public RunningHistoriesNested<A> addNewRunningHistory() {
        return new RunningHistoriesNested(-1, null);
    }

    public RunningHistoriesNested<A> addNewRunningHistoryLike(JobRunningHistory item) {
        return new RunningHistoriesNested(-1, item);
    }

    public RunningHistoriesNested<A> setNewRunningHistoryLike(int index, JobRunningHistory item) {
        return new RunningHistoriesNested(index, item);
    }

    public RunningHistoriesNested<A> editRunningHistory(int index) {
        if (this.runningHistories.size() <= index) {
            throw new RuntimeException("Can't edit runningHistories. Index exceeds size.");
        }
        return this.setNewRunningHistoryLike(index, this.buildRunningHistory(index));
    }

    public RunningHistoriesNested<A> editFirstRunningHistory() {
        if (this.runningHistories.size() == 0) {
            throw new RuntimeException("Can't edit first runningHistories. The list is empty.");
        }
        return this.setNewRunningHistoryLike(0, this.buildRunningHistory(0));
    }

    public RunningHistoriesNested<A> editLastRunningHistory() {
        int index = this.runningHistories.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last runningHistories. The list is empty.");
        }
        return this.setNewRunningHistoryLike(index, this.buildRunningHistory(index));
    }

    public RunningHistoriesNested<A> editMatchingRunningHistory(Predicate<JobRunningHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.runningHistories.size(); ++i) {
            if (!predicate.test(this.runningHistories.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching runningHistories. No match found.");
        }
        return this.setNewRunningHistoryLike(index, this.buildRunningHistory(index));
    }

    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    public A withStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
        return (A)((Object)this);
    }

    public boolean hasStartTimestamp() {
        return this.startTimestamp != null;
    }

    public String getState() {
        return this.state;
    }

    public A withState(String state) {
        this.state = state;
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusFluent that = (JobStatusFluent)((Object)o);
        if (!Objects.equals(this.endTimestamp, that.endTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.restartCount, that.restartCount)) {
            return false;
        }
        if (!Objects.equals(this.runningHistories, that.runningHistories)) {
            return false;
        }
        if (!Objects.equals(this.startTimestamp, that.startTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.endTimestamp, this.name, this.restartCount, this.runningHistories, this.startTimestamp, this.state, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endTimestamp != null) {
            sb.append("endTimestamp:");
            sb.append(this.endTimestamp + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.runningHistories != null && !this.runningHistories.isEmpty()) {
            sb.append("runningHistories:");
            sb.append(String.valueOf(this.runningHistories) + ",");
        }
        if (this.startTimestamp != null) {
            sb.append("startTimestamp:");
            sb.append(this.startTimestamp + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RunningHistoriesNested<N>
    extends JobRunningHistoryFluent<RunningHistoriesNested<N>>
    implements Nested<N> {
        JobRunningHistoryBuilder builder;
        int index;

        RunningHistoriesNested(int index, JobRunningHistory item) {
            this.index = index;
            this.builder = new JobRunningHistoryBuilder(this, item);
        }

        public N and() {
            return (N)JobStatusFluent.this.setToRunningHistories(this.index, this.builder.build());
        }

        public N endRunningHistory() {
            return this.and();
        }
    }
}

