/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.batch.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.DependsOn;
import io.fabric8.volcano.api.model.batch.v1alpha1.DependsOnBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.DependsOnFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicy;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicyBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicyFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.TaskSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TaskSpecFluent<A extends TaskSpecFluent<A>>
extends BaseFluent<A> {
    private DependsOnBuilder dependsOn;
    private Integer maxRetry;
    private Integer minAvailable;
    private String name;
    private ArrayList<LifecyclePolicyBuilder> policies = new ArrayList();
    private Integer replicas;
    private PodTemplateSpecBuilder template;
    private String topologyPolicy;
    private Map<String, Object> additionalProperties;

    public TaskSpecFluent() {
    }

    public TaskSpecFluent(TaskSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TaskSpec instance) {
        TaskSpec taskSpec = instance = instance != null ? instance : new TaskSpec();
        if (instance != null) {
            this.withDependsOn(instance.getDependsOn());
            this.withMaxRetry(instance.getMaxRetry());
            this.withMinAvailable(instance.getMinAvailable());
            this.withName(instance.getName());
            this.withPolicies(instance.getPolicies());
            this.withReplicas(instance.getReplicas());
            this.withTemplate(instance.getTemplate());
            this.withTopologyPolicy(instance.getTopologyPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DependsOn buildDependsOn() {
        return this.dependsOn != null ? this.dependsOn.build() : null;
    }

    public A withDependsOn(DependsOn dependsOn) {
        this._visitables.remove((Object)"dependsOn");
        if (dependsOn != null) {
            this.dependsOn = new DependsOnBuilder(dependsOn);
            this._visitables.get((Object)"dependsOn").add(this.dependsOn);
        } else {
            this.dependsOn = null;
            this._visitables.get((Object)"dependsOn").remove((Object)this.dependsOn);
        }
        return (A)((Object)this);
    }

    public boolean hasDependsOn() {
        return this.dependsOn != null;
    }

    public DependsOnNested<A> withNewDependsOn() {
        return new DependsOnNested(null);
    }

    public DependsOnNested<A> withNewDependsOnLike(DependsOn item) {
        return new DependsOnNested(item);
    }

    public DependsOnNested<A> editDependsOn() {
        return this.withNewDependsOnLike(Optional.ofNullable(this.buildDependsOn()).orElse(null));
    }

    public DependsOnNested<A> editOrNewDependsOn() {
        return this.withNewDependsOnLike(Optional.ofNullable(this.buildDependsOn()).orElse(new DependsOnBuilder().build()));
    }

    public DependsOnNested<A> editOrNewDependsOnLike(DependsOn item) {
        return this.withNewDependsOnLike(Optional.ofNullable(this.buildDependsOn()).orElse(item));
    }

    public Integer getMaxRetry() {
        return this.maxRetry;
    }

    public A withMaxRetry(Integer maxRetry) {
        this.maxRetry = maxRetry;
        return (A)((Object)this);
    }

    public boolean hasMaxRetry() {
        return this.maxRetry != null;
    }

    public Integer getMinAvailable() {
        return this.minAvailable;
    }

    public A withMinAvailable(Integer minAvailable) {
        this.minAvailable = minAvailable;
        return (A)((Object)this);
    }

    public boolean hasMinAvailable() {
        return this.minAvailable != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToPolicies(int index, LifecyclePolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(index, builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPolicies(int index, LifecyclePolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").set(index, builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(LifecyclePolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicies(Collection<LifecyclePolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(LifecyclePolicy ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicies(Collection<LifecyclePolicy> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<LifecyclePolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<LifecyclePolicyBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            LifecyclePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LifecyclePolicy> buildPolicies() {
        return this.policies != null ? TaskSpecFluent.build(this.policies) : null;
    }

    public LifecyclePolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public LifecyclePolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public LifecyclePolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public LifecyclePolicy buildMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        for (LifecyclePolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        for (LifecyclePolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicies(List<LifecyclePolicy> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (LifecyclePolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(LifecyclePolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (LifecyclePolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(LifecyclePolicy item) {
        return new PoliciesNested(-1, item);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, LifecyclePolicy item) {
        return new PoliciesNested(index, item);
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public String getTopologyPolicy() {
        return this.topologyPolicy;
    }

    public A withTopologyPolicy(String topologyPolicy) {
        this.topologyPolicy = topologyPolicy;
        return (A)((Object)this);
    }

    public boolean hasTopologyPolicy() {
        return this.topologyPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskSpecFluent that = (TaskSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.dependsOn, (Object)that.dependsOn)) {
            return false;
        }
        if (!Objects.equals(this.maxRetry, that.maxRetry)) {
            return false;
        }
        if (!Objects.equals(this.minAvailable, that.minAvailable)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.topologyPolicy, that.topologyPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependsOn, this.maxRetry, this.minAvailable, this.name, this.policies, this.replicas, this.template, this.topologyPolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dependsOn != null) {
            sb.append("dependsOn:");
            sb.append(this.dependsOn + ",");
        }
        if (this.maxRetry != null) {
            sb.append("maxRetry:");
            sb.append(this.maxRetry + ",");
        }
        if (this.minAvailable != null) {
            sb.append("minAvailable:");
            sb.append(this.minAvailable + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.topologyPolicy != null) {
            sb.append("topologyPolicy:");
            sb.append(this.topologyPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)TaskSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class PoliciesNested<N>
    extends LifecyclePolicyFluent<PoliciesNested<N>>
    implements Nested<N> {
        LifecyclePolicyBuilder builder;
        int index;

        PoliciesNested(int index, LifecyclePolicy item) {
            this.index = index;
            this.builder = new LifecyclePolicyBuilder(this, item);
        }

        public N and() {
            return (N)TaskSpecFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }

    public class DependsOnNested<N>
    extends DependsOnFluent<DependsOnNested<N>>
    implements Nested<N> {
        DependsOnBuilder builder;

        DependsOnNested(DependsOn item) {
            this.builder = new DependsOnBuilder(this, item);
        }

        public N and() {
            return (N)TaskSpecFluent.this.withDependsOn(this.builder.build());
        }

        public N endDependsOn() {
            return this.and();
        }
    }
}

