/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.examples;

import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.volcano.client.DefaultVolcanoClient;
import io.fabric8.volcano.examples.Utils;
import io.fabric8.volcano.scheduling.v1beta1.Queue;
import io.fabric8.volcano.scheduling.v1beta1.QueueList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class QueueCreate {
    public static void main(String[] args) {
        try (DefaultVolcanoClient volcanoClient = new DefaultVolcanoClient();){
            String queueName = "queue1";
            Queue queue = Utils.buildDefaultQueues(queueName);
            volcanoClient.queues().createOrReplace((Object)queue);
            ((Resource)volcanoClient.queues().withName(queueName)).waitUntilCondition(q -> Objects.nonNull(q.getStatus()) && q.getStatus().getState().equals("Open"), 5L, TimeUnit.SECONDS);
            System.out.println("Created: " + queue.getMetadata().getName());
            QueueList queueList = (QueueList)volcanoClient.queues().list();
            System.out.println("There are " + queueList.getItems().size() + " queue objects");
            ((Resource)volcanoClient.queues().withName(queueName)).delete();
        }
    }
}

