/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.examples;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.volcano.client.DefaultVolcanoClient;
import io.fabric8.volcano.examples.Utils;
import io.fabric8.volcano.scheduling.v1beta1.PodGroup;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PodGroupCreate {
    public static void main(String[] args) {
        try (DefaultVolcanoClient volcanoClient = new DefaultVolcanoClient();){
            String namespace = "default";
            String groupName = "group1";
            PodGroup podGroup = Utils.buildDefaultPodGroups(namespace, groupName);
            ((NonNamespaceOperation)volcanoClient.podGroups().inNamespace(namespace)).createOrReplace((Object[])new PodGroup[]{podGroup});
            System.out.println("Created: " + podGroup.getMetadata().getName());
            ((Resource)((NonNamespaceOperation)volcanoClient.podGroups().inNamespace(namespace)).withName(groupName)).waitUntilCondition(group -> Objects.nonNull(group.getStatus()) && group.getStatus().getPhase().equals("Running"), 5L, TimeUnit.SECONDS);
            System.out.println("Created: " + podGroup.getMetadata().getName());
            PodGroupList podGroupList = (PodGroupList)((NonNamespaceOperation)volcanoClient.podGroups().inNamespace(namespace)).list();
            System.out.println("There are " + podGroupList.getItems().size() + " PodGroup objects in " + namespace);
            ((Resource)((NonNamespaceOperation)volcanoClient.podGroups().inNamespace(namespace)).withName(groupName)).delete();
        }
    }
}

