/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.activemq.facade;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.BrokerFacadeCallback;
import io.fabric8.activemq.facade.BrokerViewFacade;
import io.fabric8.activemq.facade.ConnectionViewFacade;
import io.fabric8.activemq.facade.ConnectorViewFacade;
import io.fabric8.activemq.facade.DurableSubscriptionViewFacade;
import io.fabric8.activemq.facade.JobFacade;
import io.fabric8.activemq.facade.JobSchedulerViewFacade;
import io.fabric8.activemq.facade.NetworkBridgeViewFacade;
import io.fabric8.activemq.facade.NetworkConnectorViewFacade;
import io.fabric8.activemq.facade.ProducerViewFacade;
import io.fabric8.activemq.facade.QueueViewFacade;
import io.fabric8.activemq.facade.RemoteBrokerFacade;
import io.fabric8.activemq.facade.SubscriptionViewFacade;
import io.fabric8.activemq.facade.TopicViewFacade;
import io.fabric8.service.JmxTemplateSupport;
import java.util.Collection;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.activemq.command.ActiveMQDestination;

public class JmxTemplateBrokerFacade
implements BrokerFacade {
    private final JmxTemplateSupport template;

    public JmxTemplateBrokerFacade(JmxTemplateSupport template) {
        this.template = template;
    }

    public <T> T execute(final BrokerFacadeCallback<T> callback) {
        return (T)this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                RemoteBrokerFacade brokerFacade = new RemoteBrokerFacade(connection);
                return callback.doWithBrokerFacade(brokerFacade);
            }
        });
    }

    @Override
    public String getId() throws Exception {
        return this.execute(new BrokerFacadeCallback<String>(){

            @Override
            public String doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getId();
            }
        });
    }

    @Override
    public BrokerFacade[] getBrokers() throws Exception {
        return this.execute(new BrokerFacadeCallback<BrokerFacade[]>(){

            @Override
            public BrokerFacade[] doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getBrokers();
            }
        });
    }

    @Override
    public BrokerViewFacade getBrokerAdmin() throws Exception {
        return this.execute(new BrokerFacadeCallback<BrokerViewFacade>(){

            @Override
            public BrokerViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getBrokerAdmin();
            }
        });
    }

    @Override
    public String getBrokerName() throws Exception {
        return this.execute(new BrokerFacadeCallback<String>(){

            @Override
            public String doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getBrokerName();
            }
        });
    }

    @Override
    public Collection<QueueViewFacade> getQueues() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<QueueViewFacade>>(){

            @Override
            public Collection<QueueViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getQueues();
            }
        });
    }

    @Override
    public Collection<TopicViewFacade> getTopics() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<TopicViewFacade>>(){

            @Override
            public Collection<TopicViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getTopics();
            }
        });
    }

    @Override
    public Collection<SubscriptionViewFacade> getQueueConsumers(final String queueName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<SubscriptionViewFacade>>(){

            @Override
            public Collection<SubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getQueueConsumers(queueName);
            }
        });
    }

    @Override
    public Collection<SubscriptionViewFacade> getTopicConsumers(final String topicName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<SubscriptionViewFacade>>(){

            @Override
            public Collection<SubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getTopicConsumers(topicName);
            }
        });
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getTopicDurableConsumers(final String topicName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<DurableSubscriptionViewFacade>>(){

            @Override
            public Collection<DurableSubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getTopicDurableConsumers(topicName);
            }
        });
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getDurableTopicSubscribers() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<DurableSubscriptionViewFacade>>(){

            @Override
            public Collection<DurableSubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getDurableTopicSubscribers();
            }
        });
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getInactiveDurableTopicSubscribers() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<DurableSubscriptionViewFacade>>(){

            @Override
            public Collection<DurableSubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getInactiveDurableTopicSubscribers();
            }
        });
    }

    @Override
    public Collection<ProducerViewFacade> getQueueProducers(final String queueName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<ProducerViewFacade>>(){

            @Override
            public Collection<ProducerViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getQueueProducers(queueName);
            }
        });
    }

    @Override
    public Collection<ProducerViewFacade> getTopicProducers(final String topicName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<ProducerViewFacade>>(){

            @Override
            public Collection<ProducerViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getTopicProducers(topicName);
            }
        });
    }

    @Override
    public Collection<String> getConnectors() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConnectors();
            }
        });
    }

    @Override
    public ConnectorViewFacade getConnector(final String name) throws Exception {
        return this.execute(new BrokerFacadeCallback<ConnectorViewFacade>(){

            @Override
            public ConnectorViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConnector(name);
            }
        });
    }

    @Override
    public Collection<ConnectionViewFacade> getConnections() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<ConnectionViewFacade>>(){

            @Override
            public Collection<ConnectionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConnections();
            }
        });
    }

    @Override
    public Collection<String> getConnections(final String connectorName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<String>>(){

            @Override
            public Collection<String> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConnections(connectorName);
            }
        });
    }

    @Override
    public ConnectionViewFacade getConnection(final String connectionName) throws Exception {
        return this.execute(new BrokerFacadeCallback<ConnectionViewFacade>(){

            @Override
            public ConnectionViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConnection(connectionName);
            }
        });
    }

    @Override
    public Collection<SubscriptionViewFacade> getConsumersOnConnection(final String connectionName) throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<SubscriptionViewFacade>>(){

            @Override
            public Collection<SubscriptionViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getConsumersOnConnection(connectionName);
            }
        });
    }

    @Override
    public Collection<NetworkConnectorViewFacade> getNetworkConnectors() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<NetworkConnectorViewFacade>>(){

            @Override
            public Collection<NetworkConnectorViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getNetworkConnectors();
            }
        });
    }

    @Override
    public Collection<NetworkBridgeViewFacade> getNetworkBridges() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<NetworkBridgeViewFacade>>(){

            @Override
            public Collection<NetworkBridgeViewFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getNetworkBridges();
            }
        });
    }

    @Override
    public void purgeQueue(final ActiveMQDestination destination) throws Exception {
        this.execute(new BrokerFacadeCallback(){

            public Object doWithBrokerFacade(BrokerFacade broker) throws Exception {
                broker.purgeQueue(destination);
                return null;
            }
        });
    }

    @Override
    public QueueViewFacade getQueue(final String name) throws Exception {
        return this.execute(new BrokerFacadeCallback<QueueViewFacade>(){

            @Override
            public QueueViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getQueue(name);
            }
        });
    }

    @Override
    public TopicViewFacade getTopic(final String name) throws Exception {
        return this.execute(new BrokerFacadeCallback<TopicViewFacade>(){

            @Override
            public TopicViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getTopic(name);
            }
        });
    }

    @Override
    public JobSchedulerViewFacade getJobScheduler() throws Exception {
        return this.execute(new BrokerFacadeCallback<JobSchedulerViewFacade>(){

            @Override
            public JobSchedulerViewFacade doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getJobScheduler();
            }
        });
    }

    @Override
    public Collection<JobFacade> getScheduledJobs() throws Exception {
        return this.execute(new BrokerFacadeCallback<Collection<JobFacade>>(){

            @Override
            public Collection<JobFacade> doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.getScheduledJobs();
            }
        });
    }

    @Override
    public boolean isJobSchedulerStarted() {
        return this.execute(new BrokerFacadeCallback<Boolean>(){

            @Override
            public Boolean doWithBrokerFacade(BrokerFacade broker) throws Exception {
                return broker.isJobSchedulerStarted();
            }
        });
    }
}

