/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.tekton.pipeline.v1alpha1.Inputs;
import io.fabric8.tekton.pipeline.v1alpha1.InputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.InputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Outputs;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Step;
import io.fabric8.tekton.pipeline.v1alpha1.StepBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.StepFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>>
extends BaseFluent<A>
implements TaskSpecFluent<A> {
    private InputsBuilder inputs;
    private OutputsBuilder outputs;
    private List<Container> sidecars;
    private Container stepTemplate;
    private List<StepBuilder> steps;
    private List<Volume> volumes;

    public TaskSpecFluentImpl() {
    }

    public TaskSpecFluentImpl(TaskSpec instance) {
        this.withInputs(instance.getInputs());
        this.withOutputs(instance.getOutputs());
        this.withSidecars(instance.getSidecars());
        this.withStepTemplate(instance.getStepTemplate());
        this.withSteps(instance.getSteps());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    @Deprecated
    public Inputs getInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public Inputs buildInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public A withInputs(Inputs inputs) {
        this._visitables.get((Object)"inputs").remove(this.inputs);
        if (inputs != null) {
            this.inputs = new InputsBuilder(inputs);
            this._visitables.get((Object)"inputs").add(this.inputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInputs() {
        return this.inputs != null;
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputs() {
        return new InputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item) {
        return new InputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editInputs() {
        return this.withNewInputsLike(this.getInputs());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputs() {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : new InputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item) {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : item);
    }

    @Override
    @Deprecated
    public Outputs getOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public Outputs buildOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public A withOutputs(Outputs outputs) {
        this._visitables.get((Object)"outputs").remove(this.outputs);
        if (outputs != null) {
            this.outputs = new OutputsBuilder(outputs);
            this._visitables.get((Object)"outputs").add(this.outputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputs() {
        return this.outputs != null;
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputs() {
        return new OutputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item) {
        return new OutputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOutputs() {
        return this.withNewOutputsLike(this.getOutputs());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs() {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : new OutputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item) {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : item);
    }

    @Override
    public A addToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        this.sidecars.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        this.sidecars.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSidecars(Container ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.sidecars.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.sidecars.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSidecars(Container ... items) {
        for (Container item : items) {
            if (this.sidecars == null) continue;
            this.sidecars.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSidecars(Collection<Container> items) {
        for (Container item : items) {
            if (this.sidecars == null) continue;
            this.sidecars.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getSidecars() {
        return this.sidecars;
    }

    @Override
    public Container getSidecar(int index) {
        return this.sidecars.get(index);
    }

    @Override
    public Container getFirstSidecar() {
        return this.sidecars.get(0);
    }

    @Override
    public Container getLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1);
    }

    @Override
    public Container getMatchingSidecar(Predicate<Container> predicate) {
        for (Container item : this.sidecars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSidecar(Predicate<Container> predicate) {
        for (Container item : this.sidecars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSidecars(List<Container> sidecars) {
        if (this.sidecars != null) {
            this._visitables.get((Object)"sidecars").removeAll(this.sidecars);
        }
        if (sidecars != null) {
            this.sidecars = new ArrayList<Container>();
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        } else {
            this.sidecars = new ArrayList<Container>();
        }
        return (A)this;
    }

    @Override
    public A withSidecars(Container ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
        }
        if (sidecars != null) {
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    @Override
    public Container getStepTemplate() {
        return this.stepTemplate;
    }

    @Override
    public A withStepTemplate(Container stepTemplate) {
        this.stepTemplate = stepTemplate;
        return (A)this;
    }

    @Override
    public Boolean hasStepTemplate() {
        return this.stepTemplate != null;
    }

    @Override
    public A addToSteps(int index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        StepBuilder builder = new StepBuilder(item);
        this._visitables.get((Object)"steps").add(index >= 0 ? index : this._visitables.get((Object)"steps").size(), builder);
        this.steps.add(index >= 0 ? index : this.steps.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSteps(int index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        StepBuilder builder = new StepBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"steps").size()) {
            this._visitables.get((Object)"steps").add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
        }
        if (index < 0 || index >= this.steps.size()) {
            this.steps.add(builder);
        } else {
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSteps(Step ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<Step> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<StepBuilder>();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(Step ... items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<Step> items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Step> getSteps() {
        return TaskSpecFluentImpl.build(this.steps);
    }

    @Override
    public List<Step> buildSteps() {
        return TaskSpecFluentImpl.build(this.steps);
    }

    @Override
    public Step buildStep(int index) {
        return this.steps.get(index).build();
    }

    @Override
    public Step buildFirstStep() {
        return this.steps.get(0).build();
    }

    @Override
    public Step buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    @Override
    public Step buildMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<Step> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList<StepBuilder>();
            for (Step item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = new ArrayList<StepBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withSteps(Step ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (Step item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStepLike(Step item) {
        return new StepsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> setNewStepLike(int index, Step item) {
        return new StepsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editMatchingStep(Predicate<StepBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.apply((Object)this.steps.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<Volume>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskSpecFluentImpl that = (TaskSpecFluentImpl)o;
        if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) {
            return false;
        }
        if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) {
            return false;
        }
        if (this.sidecars != null ? !this.sidecars.equals(that.sidecars) : that.sidecars != null) {
            return false;
        }
        if (this.stepTemplate != null ? !this.stepTemplate.equals((Object)that.stepTemplate) : that.stepTemplate != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class StepsNestedImpl<N>
    extends StepFluentImpl<TaskSpecFluent.StepsNested<N>>
    implements TaskSpecFluent.StepsNested<N>,
    Nested<N> {
        private final StepBuilder builder;
        private final int index;

        StepsNestedImpl(int index, Step item) {
            this.index = index;
            this.builder = new StepBuilder(this, item);
        }

        StepsNestedImpl() {
            this.index = -1;
            this.builder = new StepBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToSteps(this.index, this.builder.build());
        }

        @Override
        public N endStep() {
            return this.and();
        }
    }

    public class OutputsNestedImpl<N>
    extends OutputsFluentImpl<TaskSpecFluent.OutputsNested<N>>
    implements TaskSpecFluent.OutputsNested<N>,
    Nested<N> {
        private final OutputsBuilder builder;

        OutputsNestedImpl(Outputs item) {
            this.builder = new OutputsBuilder(this, item);
        }

        OutputsNestedImpl() {
            this.builder = new OutputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withOutputs(this.builder.build());
        }

        @Override
        public N endOutputs() {
            return this.and();
        }
    }

    public class InputsNestedImpl<N>
    extends InputsFluentImpl<TaskSpecFluent.InputsNested<N>>
    implements TaskSpecFluent.InputsNested<N>,
    Nested<N> {
        private final InputsBuilder builder;

        InputsNestedImpl(Inputs item) {
            this.builder = new InputsBuilder(this, item);
        }

        InputsNestedImpl() {
            this.builder = new InputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withInputs(this.builder.build());
        }

        @Override
        public N endInputs() {
            return this.and();
        }
    }
}

