/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.swagger.model.Api;
import io.fabric8.swagger.model.Authorizations_;
import io.fabric8.swagger.model.Models;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"swaggerVersion", "apiVersion", "basePath", "resourcePath", "apis", "models", "produces", "consumes", "authorizations"})
public class ApiDeclaration {
    @JsonProperty(value="swaggerVersion")
    private SwaggerVersion swaggerVersion;
    @JsonProperty(value="apiVersion")
    private String apiVersion;
    @JsonProperty(value="basePath")
    @Pattern(regexp="^https?://")
    private URI basePath;
    @JsonProperty(value="resourcePath")
    @Pattern(regexp="^/")
    private String resourcePath;
    @JsonProperty(value="apis")
    @Valid
    private List<Api> apis = new ArrayList<Api>();
    @JsonProperty(value="models")
    @Valid
    private Models models;
    @JsonProperty(value="produces")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty(value="consumes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty(value="authorizations")
    @Valid
    private Authorizations_ authorizations;

    @JsonProperty(value="swaggerVersion")
    public SwaggerVersion getSwaggerVersion() {
        return this.swaggerVersion;
    }

    @JsonProperty(value="swaggerVersion")
    public void setSwaggerVersion(SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="basePath")
    public URI getBasePath() {
        return this.basePath;
    }

    @JsonProperty(value="basePath")
    public void setBasePath(URI basePath) {
        this.basePath = basePath;
    }

    @JsonProperty(value="resourcePath")
    public String getResourcePath() {
        return this.resourcePath;
    }

    @JsonProperty(value="resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @JsonProperty(value="apis")
    public List<Api> getApis() {
        return this.apis;
    }

    @JsonProperty(value="apis")
    public void setApis(List<Api> apis) {
        this.apis = apis;
    }

    @JsonProperty(value="models")
    public Models getModels() {
        return this.models;
    }

    @JsonProperty(value="models")
    public void setModels(Models models) {
        this.models = models;
    }

    @JsonProperty(value="produces")
    public Set<String> getProduces() {
        return this.produces;
    }

    @JsonProperty(value="produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonProperty(value="consumes")
    public Set<String> getConsumes() {
        return this.consumes;
    }

    @JsonProperty(value="consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @JsonProperty(value="authorizations")
    public Authorizations_ getAuthorizations() {
        return this.authorizations;
    }

    @JsonProperty(value="authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    public String toString() {
        return "ApiDeclaration(swaggerVersion=" + (Object)((Object)this.getSwaggerVersion()) + ", apiVersion=" + this.getApiVersion() + ", basePath=" + this.getBasePath() + ", resourcePath=" + this.getResourcePath() + ", apis=" + this.getApis() + ", models=" + this.getModels() + ", produces=" + this.getProduces() + ", consumes=" + this.getConsumes() + ", authorizations=" + this.getAuthorizations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiDeclaration)) {
            return false;
        }
        ApiDeclaration other = (ApiDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SwaggerVersion this$swaggerVersion = this.getSwaggerVersion();
        SwaggerVersion other$swaggerVersion = other.getSwaggerVersion();
        if (this$swaggerVersion == null ? other$swaggerVersion != null : !((Object)((Object)this$swaggerVersion)).equals((Object)other$swaggerVersion)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        URI this$basePath = this.getBasePath();
        URI other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !((Object)this$basePath).equals(other$basePath)) {
            return false;
        }
        String this$resourcePath = this.getResourcePath();
        String other$resourcePath = other.getResourcePath();
        if (this$resourcePath == null ? other$resourcePath != null : !this$resourcePath.equals(other$resourcePath)) {
            return false;
        }
        List<Api> this$apis = this.getApis();
        List<Api> other$apis = other.getApis();
        if (this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis)) {
            return false;
        }
        Models this$models = this.getModels();
        Models other$models = other.getModels();
        if (this$models == null ? other$models != null : !this$models.equals(other$models)) {
            return false;
        }
        Set<String> this$produces = this.getProduces();
        Set<String> other$produces = other.getProduces();
        if (this$produces == null ? other$produces != null : !((Object)this$produces).equals(other$produces)) {
            return false;
        }
        Set<String> this$consumes = this.getConsumes();
        Set<String> other$consumes = other.getConsumes();
        if (this$consumes == null ? other$consumes != null : !((Object)this$consumes).equals(other$consumes)) {
            return false;
        }
        Authorizations_ this$authorizations = this.getAuthorizations();
        Authorizations_ other$authorizations = other.getAuthorizations();
        return !(this$authorizations == null ? other$authorizations != null : !this$authorizations.equals(other$authorizations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiDeclaration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SwaggerVersion $swaggerVersion = this.getSwaggerVersion();
        result = result * 59 + ($swaggerVersion == null ? 43 : ((Object)((Object)$swaggerVersion)).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        URI $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : ((Object)$basePath).hashCode());
        String $resourcePath = this.getResourcePath();
        result = result * 59 + ($resourcePath == null ? 43 : $resourcePath.hashCode());
        List<Api> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        Models $models = this.getModels();
        result = result * 59 + ($models == null ? 43 : $models.hashCode());
        Set<String> $produces = this.getProduces();
        result = result * 59 + ($produces == null ? 43 : ((Object)$produces).hashCode());
        Set<String> $consumes = this.getConsumes();
        result = result * 59 + ($consumes == null ? 43 : ((Object)$consumes).hashCode());
        Authorizations_ $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : $authorizations.hashCode());
        return result;
    }

    public static enum SwaggerVersion {
        _1_2("1.2");

        private final String value;
        private static Map<String, SwaggerVersion> constants;

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SwaggerVersion fromValue(String value) {
            SwaggerVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, SwaggerVersion>();
            for (SwaggerVersion c : SwaggerVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

