/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.tomcat;

import io.fabric8.runtime.container.ContainerConfiguration;
import java.io.IOException;
import java.util.Properties;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.runtime.RuntimeType;

public final class TomcatContainerConfiguration
extends ContainerConfiguration {
    public static final String DEFAULT_JAVAVM_ARGUMENTS = "-Xmx512m -XX:MaxPermSize=128m";

    public RuntimeType getRuntimeType() {
        return RuntimeType.TOMCAT;
    }

    protected void validate() {
        if (this.getMavenCoordinates().isEmpty()) {
            Properties properties = new Properties();
            try {
                properties.load(((Object)((Object)this)).getClass().getResourceAsStream("version.properties"));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load version.properties", ex);
            }
            String tomcatVersion = properties.getProperty("tomcat.version");
            String projectVersion = properties.getProperty("project.version");
            this.addMavenCoordinates(MavenCoordinates.create((String)"org.apache.tomcat", (String)"tomcat", (String)tomcatVersion, (String)"zip", null));
            this.addMavenCoordinates(MavenCoordinates.create((String)"io.fabric8.runtime", (String)"fabric-runtime-container-tomcat-patch", (String)projectVersion, (String)"zip", null));
        }
        super.validate();
    }
}

