/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container;

import io.fabric8.runtime.container.ContainerConfiguration;
import io.fabric8.runtime.container.LifecycleException;
import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;

public interface ManagedContainer<T extends ContainerConfiguration> {
    public File getContainerHome();

    public State getState();

    public void create(T var1) throws LifecycleException;

    public void start() throws LifecycleException;

    public void stop() throws LifecycleException;

    public void destroy() throws LifecycleException;

    public static class Factory<T extends ContainerConfiguration> {
        public static <T extends ContainerConfiguration> ManagedContainer<T> create(T configuration) throws LifecycleException {
            ServiceLoader<ManagedContainer> loader = ServiceLoader.load(ManagedContainer.class);
            Iterator<ManagedContainer> iterator = loader.iterator();
            if (iterator.hasNext()) {
                ManagedContainer service = iterator.next();
                service.create(configuration);
                return service;
            }
            throw new IllegalStateException("Cannot obtain managed container service");
        }
    }

    public static enum State {
        CREATED,
        STARTED,
        STOPPED,
        DESTROYED;

    }
}

