/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.agent;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Strings;
import io.fabric8.runtime.agent.FabricAgentMXBean;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.karaf.features.Feature;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.runtime.agent.FabricAgent", label="Fabric8 Runtime Agent", immediate=true, policy=ConfigurationPolicy.IGNORE, metatype=false)
public class FabricAgent
extends AbstractComponent
implements FabricAgentMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricAgent.class);
    private static final String SERVICE_COMPONENT = "Service-Component";
    private static final String GENRATED_RESOURCE_IDENTITY = "io.fabric8.generated.fabric-profile";
    private static final String GENRATED_MAVEN_COORDS = "mvn:io.fabric8.generated/fabric-profile/1.0.0/war";
    private static final Pattern VALID_COMPONENT_PATH_PATTERN = Pattern.compile("[_a-zA-Z0-9\\-\\./]+");
    @Reference(referenceInterface=MBeanServer.class)
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();
    @Reference(referenceInterface=Provisioner.class)
    private final ValidatingReference<Provisioner> provisioner = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerRegistration.class)
    private final ValidatingReference<ContainerRegistration> containerRegistration = new ValidatingReference();
    private final Runnable onConfigurationChange = new Runnable(){

        @Override
        public void run() {
            FabricAgent.this.submitUpdateJob();
        }
    };
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric8-agent"));
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric8-agent-downloader"));
    private ObjectName objectName;
    private Map<ResourceIdentity, ResourceHandle> resourcehandleMap = new ConcurrentHashMap<ResourceIdentity, ResourceHandle>();
    private ComponentContext componentContext;

    @Activate
    void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        LOGGER.info("Activating");
        ((FabricService)this.fabricService.get()).trackConfiguration(this.onConfigurationChange);
        this.activateComponent();
        this.submitUpdateJob();
        try {
            MBeanServer anMBeanServer = (MBeanServer)this.mbeanServer.get();
            if (anMBeanServer != null) {
                if (this.objectName == null) {
                    this.objectName = new ObjectName("io.fabric8:type=RuntimeAgent");
                }
                anMBeanServer.registerMBean(this, this.objectName);
            } else {
                LOGGER.warn("No MBeanServer");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register MBean " + this.objectName + ": " + e, (Throwable)e);
        }
    }

    @Deactivate
    void deactivate() {
        if (this.objectName != null) {
            try {
                MBeanServer anMBeanServer = (MBeanServer)this.mbeanServer.get();
                if (anMBeanServer != null) {
                    anMBeanServer.unregisterMBean(this.objectName);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to unregister MBean " + this.objectName + ": " + e, (Throwable)e);
            }
        }
        this.deactivateComponent();
        ((FabricService)this.fabricService.get()).untrackConfiguration(this.onConfigurationChange);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    private void submitUpdateJob() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (FabricAgent.this.isValid()) {
                    try {
                        FabricAgent.this.updateInternal();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught:" + e, (Throwable)e);
                    }
                }
            }
        });
    }

    protected synchronized void updateInternal() {
        Profile profile = null;
        FabricService fabric = null;
        Provisioner provisionService = null;
        try {
            fabric = (FabricService)this.fabricService.get();
            Container container = fabric.getCurrentContainer();
            profile = container.getOverlayProfile();
            provisionService = (Provisioner)this.provisioner.get();
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to read container profile. This exception will be ignored..", (Throwable)ex);
            return;
        }
        if (profile != null && fabric != null && provisionService != null) {
            List<String> resources = null;
            try {
                Map<String, File> artifacts = this.downloadProfileArtifacts(fabric, profile);
                this.populateExplodedWar(artifacts);
                resources = this.updateProvisioning(artifacts, provisionService);
                this.updateStatus("success", null, resources);
            }
            catch (Throwable e) {
                if (this.isValid()) {
                    LOGGER.warn("Exception updating provisioning: " + e, e);
                    this.updateStatus("error", e, resources);
                }
                LOGGER.debug("Exception updating provisioning: " + e, e);
            }
        }
    }

    protected void updateStatus(String status, Throwable result, List<String> resources) {
        try {
            FabricService fs = (FabricService)this.fabricService.get();
            if (fs != null) {
                String e;
                Container container = fs.getCurrentContainer();
                if (result == null) {
                    e = null;
                } else {
                    StringWriter sw = new StringWriter();
                    result.printStackTrace(new PrintWriter(sw));
                    e = sw.toString();
                }
                if (resources != null) {
                    container.setProvisionList(resources);
                }
                container.setProvisionResult(status);
                container.setProvisionException(e);
            } else {
                LOGGER.info("FabricService not available");
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    protected Map<String, File> downloadProfileArtifacts(FabricService fabric, Profile profile) throws Exception {
        this.updateStatus("downloading", null, null);
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        bundles.addAll(profile.getBundles());
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(fabric, this.downloadExecutor);
        AgentUtils.addFeatures(features, fabric, downloadManager, profile);
        return AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateExplodedWar(Map<String, File> artifacts) throws IOException {
        this.updateStatus("populating profile war", null, null);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FabricAgent.class.getClassLoader());
            WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"profile.war");
            final HashSet<String> components = new HashSet<String>();
            for (Map.Entry<String, File> entry : artifacts.entrySet()) {
                File f;
                String name = entry.getKey();
                if (FabricAgent.isWar(name, f = entry.getValue())) continue;
                archive.addAsLibrary(f);
                Manifest mf = FabricAgent.readManifest(f);
                if (!mf.getMainAttributes().containsKey(new Attributes.Name(SERVICE_COMPONENT))) continue;
                String serviceComponents = mf.getMainAttributes().getValue(SERVICE_COMPONENT);
                for (String component : Strings.splitAndTrimAsList((String)serviceComponents, (String)",")) {
                    if (!VALID_COMPONENT_PATH_PATTERN.matcher(component).matches()) continue;
                    archive.add((Asset)new ZipFileEntryAsset(new ZipFile(f, 1), new ZipEntry(component)), component);
                    components.add(component);
                }
            }
            archive.addClass(WebAppContextListener.class);
            archive.addAsWebInfResource("web.xml");
            archive.addAsWebResource("context.xml", "META-INF/context.xml");
            archive.setManifest(new Asset(){

                public InputStream openStream() {
                    return new ManifestBuilder().addIdentityCapability(FabricAgent.GENRATED_RESOURCE_IDENTITY, "1.0.0").addManifestHeader(FabricAgent.SERVICE_COMPONENT, Strings.join((Collection)components, (String)",")).openStream();
                }
            });
            File profileWar = this.componentContext.getBundleContext().getDataFile("fabric-profile.war");
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(profileWar, true);
            artifacts.put(GENRATED_MAVEN_COORDS, profileWar);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        this.updateStatus("populated profile war", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest readManifest(File file) throws IOException {
        Manifest manifest;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            JarInputStream jis = new JarInputStream(fis);
            manifest = jis.getManifest();
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(fis);
            throw throwable;
        }
        Closeables.closeQuitely((Closeable)fis);
        return manifest;
    }

    protected List<String> updateProvisioning(Map<String, File> artifacts, Provisioner provisionService) throws Exception {
        ResourceInstaller resourceInstaller = provisionService.getResourceInstaller();
        Map<ResourceIdentity, Resource> installedResources = this.getInstalledResources(provisionService);
        HashMap requirements = new HashMap();
        Set<Map.Entry<String, File>> entries = artifacts.entrySet();
        ArrayList<Resource> resourcesToInstall = new ArrayList<Resource>();
        ArrayList<String> resourceUrisInstalled = new ArrayList<String>();
        this.updateStatus("installing", null, null);
        for (Map.Entry<String, File> entry : entries) {
            String name = entry.getKey();
            File file = entry.getValue();
            String coords = name;
            int idx = coords.lastIndexOf(58);
            if (idx > 0) {
                coords = name.substring(idx + 1);
            }
            coords = coords.replace('/', ':');
            MavenCoordinates mvnCoords = FabricAgent.parse(coords);
            URL url = file.toURI().toURL();
            if (url == null) {
                LOGGER.warn("Could not find URL for file " + file);
                continue;
            }
            boolean isShared = !FabricAgent.isWar(name, file);
            Resource resource = this.findMavenResource(mvnCoords, url, isShared);
            if (resource == null) {
                LOGGER.warn("Could not find resource for " + mvnCoords + " and " + url);
                continue;
            }
            ResourceIdentity identity = resource.getIdentity();
            Resource oldResource = installedResources.remove(identity);
            if (oldResource != null || this.resourcehandleMap.containsKey(identity)) continue;
            if (isShared) {
                LOGGER.debug("TODO not installing " + (isShared ? "shared" : "non-shared") + " resource: " + identity);
                continue;
            }
            LOGGER.info("Installing " + (isShared ? "shared" : "non-shared") + " resource: " + identity);
            resourcesToInstall.add(resource);
            resourceUrisInstalled.add(name);
        }
        for (Resource installedResource : installedResources.values()) {
            ResourceIdentity identity = installedResource.getIdentity();
            ResourceHandle resourceHandle = this.resourcehandleMap.get(identity);
            if (resourceHandle == null) {
                LOGGER.warn("TODO: Cannot uninstall " + installedResource + " as we have no handle!");
                continue;
            }
            LOGGER.info("Uninstalling " + installedResource);
            resourceHandle.uninstall();
            this.resourcehandleMap.remove(identity);
            LOGGER.info("Uninstalled " + installedResource);
        }
        if (resourcesToInstall.size() > 0) {
            LOGGER.info("Installing " + resourcesToInstall.size() + " resource(s)");
            LinkedHashSet<ResourceHandle> resourceHandles = new LinkedHashSet<ResourceHandle>();
            DefaultInstallerContext context = new DefaultInstallerContext(resourcesToInstall, requirements);
            for (Resource resource : resourcesToInstall) {
                resourceHandles.add(resourceInstaller.installResource((ResourceInstaller.Context)context, resource));
            }
            LOGGER.info("Got " + resourceHandles.size() + " resource handle(s)");
            for (ResourceHandle resourceHandle : resourceHandles) {
                this.resourcehandleMap.put(resourceHandle.getResource().getIdentity(), resourceHandle);
            }
        }
        return resourceUrisInstalled;
    }

    protected Map<ResourceIdentity, Resource> getInstalledResources(Provisioner provisionService) {
        HashMap<ResourceIdentity, Resource> installedResources = new HashMap<ResourceIdentity, Resource>();
        for (Map.Entry<ResourceIdentity, ResourceHandle> entry : this.resourcehandleMap.entrySet()) {
            installedResources.put(entry.getKey(), entry.getValue().getResource());
        }
        try {
            Iterator resources = provisionService.getEnvironment().getResources();
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                installedResources.put(resource.getIdentity(), resource);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Ignoring error finding current resources: " + e, e);
        }
        return installedResources;
    }

    public Resource findMavenResource(MavenCoordinates mavenid, URL contentURL, boolean isShared) {
        LOGGER.debug("Find maven providers for: {}", (Object)mavenid);
        Resource result = null;
        if (contentURL != null) {
            DefaultResourceBuilder builder = new DefaultResourceBuilder();
            Capability identCap = builder.addIdentityCapability(mavenid);
            Capability ccap = builder.addCapability("gravia.content", null, null);
            ccap.getAttributes().put("url", contentURL);
            if (isShared) {
                identCap.getAttributes().put("shared", "true");
            } else {
                identCap.getAttributes().put("contextPath", mavenid.getArtifactId());
            }
            result = builder.getResource();
            LOGGER.debug("Found maven resource: {}", (Object)result);
        }
        return result;
    }

    private static boolean isWar(String name, File file) {
        return name.startsWith("war:") || name.contains("/war/") || file.getName().toLowerCase().endsWith(".war");
    }

    private static MavenCoordinates parse(String coordinates) {
        MavenCoordinates result;
        String[] parts = coordinates.split(":");
        if (parts.length == 3) {
            result = MavenCoordinates.create((String)parts[0], (String)parts[1], (String)parts[2], null, null);
        } else if (parts.length == 4) {
            result = MavenCoordinates.create((String)parts[0], (String)parts[1], (String)parts[2], (String)parts[3], null);
        } else if (parts.length == 5) {
            result = MavenCoordinates.create((String)parts[0], (String)parts[1], (String)parts[2], (String)parts[3], (String)parts[4]);
        } else {
            throw new IllegalArgumentException("Invalid coordinates: " + coordinates);
        }
        return result;
    }

    void bindMbeanServer(MBeanServer service) {
        this.mbeanServer.bind((Object)service);
    }

    void unbindMbeanServer(MBeanServer service) {
        this.mbeanServer.unbind((Object)service);
    }

    void bindProvisioner(Provisioner service) {
        this.provisioner.bind((Object)service);
    }

    void unbindProvisioner(Provisioner service) {
        this.provisioner.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.bind((Object)service);
    }

    void unbindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.unbind((Object)service);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

